package com.liveperson.messaging;

import android.content.Context;

import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;

/**
 * Created by dudu on 2/8/16.
 */
public class MessagingFactory {
    protected static MessagingFactory instance;
    protected Messaging messagingController;

    protected MessagingFactory() {}

    public static MessagingFactory getInstance() {
        if (instance == null){
            synchronized (MessagingFactory.class){
                if (instance == null){
                    instance = new MessagingFactory();
                }
            }
        }
        return instance;
    }

    public synchronized void init(Context context, MessagingInitData initData, InitProcess initProcess) {
        initializeMessaging();
        messagingController.init(context, initData, initProcess);
    }

    private void initializeMessaging() {
        if (messagingController == null) {
            messagingController = new Messaging();
        }
    }


    public Messaging getController() {
        return messagingController;
    }

    protected void bootstrapRegistration() {
        messagingController.bootstrapRegistration();
    }

//    public void restart() {
//        messagingController.restart();
//    }

    public void shutDown(ShutDownProcess shutDownProcess) {
        messagingController.shutDown(shutDownProcess);
    }

    public void logout(Context context, MessagingInitData initData, LogoutProcess logoutProcess) {
        initializeMessaging();
        messagingController.logout(context, initData, logoutProcess);
    }

    public boolean isInitialized() {
        return messagingController.isInitialized();
    }

//    public void connect(String brandId, String authKey) {
//        messagingController.connect(brandId,  authKey);
//    }
//
//    protected void initBrand(String brandId) {
//        messagingController.init();
//    }
//
//    public void disconnect(String brandId) {
//        messagingController.disconnect(brandId);
//    }
//
//    public void sendMessage(String targetId, String brandId, String message) {
//        messagingController.sendMessage(targetId, brandId, message);
//    }
//
//    public void resendMessage(long requestId, String conversationId, String message) {
//        messagingController.resendMessage(requestId, conversationId, message);
//    }
//
//    public void registerPusher(String brandId, String token) {
//        messagingController.registerPusher(brandId, token);
//    }
//
//    public void changeChatState(String targetId, String brandId, ChatState state) {
//        messagingController.changeChatState(targetId, brandId, state);
//    }
//
//    public void resolveConversation(String targetId, String brandId) {
//        messagingController.resolveConversation(targetId, brandId);
//    }
//
//    public void markConversationAsUrgent(String targetId, String brandId) {
//        messagingController.markConversationAsUrgent(targetId, brandId);
//    }
//
//    public void markConversationAsNormal(String targetId, String brandId) {
//        messagingController.markConversationAsNormal(targetId, brandId);
//    }
//
//    public void sendCsat(String brandId, String conversationID, int mStarsNumber, int yesNoValue) {
//        messagingController.sendCsat(brandId, conversationID, mStarsNumber, yesNoValue);
//    }
//
//    public void sendUserProfile(String brandId, UserProfileBundle userProfileBundle) {
//        messagingController.sendUserProfile(brandId, userProfileBundle);
//    }
//
//    public void setCallback(LivePersonCallback listener){
//        messagingController.setCallback(listener);
//    }
//
//    public void removeCallback() {
//        messagingController.removeCallback();
//    }
//
//    public void shutDown() {
//        //TODO: Need to add all the components here
//    }
//
//    public String getOriginatorId(String targetId) {
//        return messagingController.getOriginatorId(targetId);
//    }
}
