package com.liveperson.messaging.background;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.commands.ReSendImageCommand;
import com.liveperson.messaging.exception.FileSharingException;

import java.io.IOException;

/**
 * Created by shiranr on 7/24/16.
 */
public class ReUploadImageTask extends UploadImageTask {

    private static final String TAG = ReUploadImageTask.class.getSimpleName();

    /**
     * creating bitmaps (thumbnail and full size)
     *
     * @param params
     */
    public ReUploadImageTask(ReUploadImageTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(params, uploadTimeout);

        mFileRowId = params.getFileRowId();
        LPMobileLog.d(TAG + Thread.currentThread(), "imageTypeExtension = " + uploadImageTaskParams.getFileTypeExtension() + ", imageContentType = " + uploadImageTaskParams.getFileContentType());
    }


    @Override
    protected Bitmap processOriginalImage(int orientation, boolean fromCamera) throws IOException, FileSharingException {
        Bitmap originalBitmap = ImageUtils.getBitmap(uploadImageTaskParams.getFilePath());
        LPMobileLog.d(TAG + Thread.currentThread(), "originalBitmap size (w, h): " + originalBitmap.getWidth() + ", " + originalBitmap.getHeight());
        return originalBitmap;
    }

    @NonNull
    @Override
    protected String saveOriginalImage(Bitmap originalBitmap) throws FileSharingException {
        // Create a byte array of the image. If the image is NOT from the camera, save it to local folder
        createOriginalImageByteArray(originalBitmap, uploadImageTaskParams.getFileTypeExtension());
        return uploadImageTaskParams.getFilePath();
    }

    @Override
    protected Bitmap processThumbnailImage(int orientation, boolean fromCamera) throws IOException, FileSharingException {
        return ImageUtils.getBitmap(((ReUploadImageTaskBundle) uploadImageTaskParams).getThumbnailLocalPath());
    }

    @NonNull
    @Override
    protected String saveThumbnailImage(Bitmap thumbnailBitmap) throws FileSharingException {

        byte [] thumbnailByteArray = ImageUtils.getOutputStreamFromBitmap(thumbnailBitmap, 100, uploadImageTaskParams.getFileTypeExtension());
        // If thumbnail was not created successfully return null
        if (thumbnailByteArray == null) {
            return null;
        }
        // Encode thumbnail's base64 string
        mBase64 = ImageUtils.bitmapToBase64(thumbnailByteArray);
        LPMobileLog.d(TAG + Thread.currentThread(), "processThumbnailImage: Thumbnail Base64: " + mBase64);
        return ((ReUploadImageTaskBundle) uploadImageTaskParams).getThumbnailLocalPath();
    }

    protected void createSendMessageCommand(String thumbnailPath, String fullImagePath)  {

        sendMessageCommand = new ReSendImageCommand(MessagingFactory.getInstance().getController(),
                uploadImageTaskParams.getTargetId(),
                uploadImageTaskParams.getBrandId(),
                uploadImageTaskParams.getFileContentType(),
                thumbnailPath,
                fullImagePath,
                uploadImageTaskParams.getFileTypeExtension(),
                ((ReUploadImageTaskBundle) uploadImageTaskParams).getEventId(),
                uploadImageTaskParams.getMessage(),
                ((ReUploadImageTaskBundle) uploadImageTaskParams).getOriginalMessageTime(),
                ((ReUploadImageTaskBundle) uploadImageTaskParams).getFileRowId());

        setSendMessageCommandCallback();
    }


}