package com.liveperson.messaging.background.filesharing.image;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

/**
 * Created by shiranr on 7/24/16.
 */
public class UploadImageTaskBundle extends UploadFileTaskBundle {

    private static final String TAG = "UploadImageTaskBundle";

	private boolean mImageFromCamera;

	public UploadImageTaskBundle addBrandId(String brandId) {
		super.addBrandId(brandId);
        return this;
    }

    public UploadImageTaskBundle addTargetId(String targetId) {
		super.addTargetId(targetId);
        return this;
    }

	public UploadImageTaskBundle addSwiftDomain(String swiftDomain) {
		super.addSwiftDomain(swiftDomain);
		return this;
	}

	public UploadImageTaskBundle addRestDomain(RestRequestParams restRequestParams) {
		super.addRestDomain(restRequestParams);
		return this;
	}

	public UploadImageTaskBundle addFileUri(Uri fileUri) {
		super.addFileUri(fileUri);
        return this;
    }

    public UploadImageTaskBundle addMessage(MaskedMessage maskedMessage) {
		super.addMessage(maskedMessage);
        return this;
    }


	public UploadImageTaskBundle addImageFromCamera(boolean imageFromCamera) {
		mImageFromCamera = imageFromCamera;
		return this;
	}

	public UploadImageTaskBundle build(int taskId, Context context){
        setTaskID(taskId);

        mFilePath = ImageUtils.getImagePath(context, mFileUri, mBrandId);

		// If the scheme of the file is 'content' (e.g. content://... - usually from gallery) we get the info from the content resolver
		if (mFileUri.getScheme().equals(ContentResolver.SCHEME_CONTENT)) {
			ContentResolver cR = context.getContentResolver();
			MimeTypeMap mime = MimeTypeMap.getSingleton();
			mFileContentType = cR.getType(mFileUri);
			if (mFileContentType != null) {
				String extensionFromMimeType = mime.getExtensionFromMimeType(mFileContentType);
				if (extensionFromMimeType != null) {
					mFileTypeExtension = extensionFromMimeType.toUpperCase();
				}
			}
		}
		else{ // The scheme is NOT 'content'. It means we have a file:// scheme (usually from camera) so we get the info from the file

			String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(mFileUri.toString());
			if (fileExtensionFromUrl != null) {
				mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
			}

			if (mFileTypeExtension != null) {
				mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mFileTypeExtension.toLowerCase());
			}
		}

        return this;
    }




	public boolean isImageFromCamera() {
		return mImageFromCamera;
	}

}
