package com.liveperson.messaging.commands;

import android.support.annotation.Nullable;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LPAuthenticationParams;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.requests.PushRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.controller.connection.ConnectionParamsCache;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;

import java.util.List;

/**
 * Created by Ilya Gazman on 11/26/2015.
 */
public class RegisterPusherCommand implements Command {

    private static final String TAG = RegisterPusherCommand.class.getSimpleName();
    private static final String PUSHER_URL = "https://%s/api/account/%s/device/register";
    private final Messaging mController;
    private final LPAuthenticationParams mLpAuthParams;
    private String mBrandId;
    private String mToken;
    private String mAppId;
    @Nullable
    private ICallback<Void, Exception> mRegistrationCompletedCallback;

    public RegisterPusherCommand(Messaging messagingController, String brandId, String appId, String token, LPAuthenticationParams lpAuthParams,final ICallback<Void, Exception> registrationCompletedCallback) {
        mController = messagingController;
        mBrandId = brandId;
        mToken = token;
        mAppId = appId;
        mLpAuthParams = lpAuthParams;
        mRegistrationCompletedCallback = registrationCompletedCallback;
    }

    @Override
    public void execute() {
        LPMobileLog.i(TAG, "execute with token " + mToken);
        boolean isExecuting = new SynchronizedAuthenticationCompletedCallback(mController.mAccountsController, mBrandId, new ICallback<Void, Exception> (){
            @Override
            public void onSuccess(Void value) {
                List<String> certificates = mController.mAccountsController.getCertificatePinningKeys(mBrandId);
                String pusherDomain = mController.mAccountsController.getServiceUrl(mBrandId, ConnectionParamsCache.CSDS_PUSHER_DOMAIN_KEY);
                String pusherURL = String.format(PUSHER_URL, pusherDomain, mBrandId);
                LPMobileLog.i(TAG, "Running register pusher with token " + mToken);
                GetCombinedUnreadMessagesCountCommand.setIsRegisteredToPusher(true); // We have to set it here assuming registration will be a success
                new PushRequest(pusherURL, mController.amsUsers.getConsumerId(mBrandId),
                        mAppId, mToken, mController.mAccountsController.getToken(mBrandId), certificates).setCallback(mRegistrationCompletedCallback).execute();
            }

            @Override
            public void onError(Exception exception) {
                if (mRegistrationCompletedCallback != null) {
                    mRegistrationCompletedCallback.onError(exception);
                }
            }

        }).executeWithReturnValue();
        //in case we have valid jwt we will execute the register request. otherwise, we'll try to connect.
        if (!isExecuting && mLpAuthParams != null){
            mController.connect(mBrandId, mLpAuthParams, null, true, false);
        }
    }
}