package com.liveperson.messaging.commands;

import android.text.TextUtils;

import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Command;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.SynchronizedAmsConnectionCallback;
import com.liveperson.messaging.model.UserProfileBundle;
import com.liveperson.messaging.network.socket.requests.SetUsersProfileRequest;

/**
 * Send a setUserProfile request to the server
 * <p/>
 * Created by nirni on 12/22/15.
 */
public class SendSetUserProfileCommand implements Command {

    public static final String TAG = SetUsersProfileRequest.class.getSimpleName();
    private final Messaging mController;

    private String mBrandId;
    private UserProfileBundle mUserProfileBundle;

    public SendSetUserProfileCommand(Messaging messagingController, String brandId, UserProfileBundle userProfileBundle) {
        mController = messagingController;
        mBrandId = brandId;
        mUserProfileBundle = userProfileBundle;
    }

    @Override
    public void execute() {
        LPMobileLog.i(TAG, "Running SetUserProfile request...");
        new SynchronizedAmsConnectionCallback(mController.mConnectionController, mBrandId, new Runnable() {
            @Override
            public void run() {

                if (TextUtils.isEmpty(mBrandId)) {
                    LPMobileLog.e(TAG, "execute: BrandId is empty. Cannot proceed with set user profile");
                    return;
                }

                String consumerId = mController.amsUsers.getConsumerId(mBrandId);
                LPMobileLog.d(TAG, "consumer id " + consumerId + "\n" +
                        "First name " + mUserProfileBundle.getFirstName() + "\n" +
                        "Last name " + mUserProfileBundle.getLastName() + "\n" +
                        "Phone number " + mUserProfileBundle.getPhoneNumber() + "\n" +
                        "Nick name " + mUserProfileBundle.getNickname() + "\n" +
                        "Avatar URL " + mUserProfileBundle.getAvatarUrl());

                MessagingUserProfile msgUserProfile = new MessagingUserProfile(mUserProfileBundle.getFirstName(), mUserProfileBundle.getLastName(), UserProfile.UserType.CONSUMER);
                msgUserProfile.setAvatarUrl(mUserProfileBundle.getAvatarUrl());
                msgUserProfile.setNickname(mUserProfileBundle.getNickname());
                msgUserProfile.setDescription(mUserProfileBundle.getPhoneNumber());
                msgUserProfile.setPrivateData(new UserProfile.PrivateData("", "")); //TODO: do we need this one?
                msgUserProfile.setMobileNumber(mUserProfileBundle.getPhoneNumber());
                msgUserProfile.setOriginatorID(consumerId);

                // Send the request
                SetUsersProfileRequest setUsersProfileRequest = new SetUsersProfileRequest(
                        mController.amsUsers, mController.mAccountsController.getConnectionUrl(mBrandId), mBrandId, msgUserProfile);
                SocketManager.getInstance().send(setUsersProfileRequest);
            }
        }).execute();
    }
}