package com.liveperson.messaging.commands.tasks;

import com.liveperson.api.request.GetClock;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.network.socket.general_requests.ClockRequest;

/**
 * Created by shiranr on 29/11/2015.
 */
public class GetClockTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = GetClockTask.class.getSimpleName();
    private final Messaging mController;

    public GetClockTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
        LPMobileLog.i(TAG, "Running get clock task...");
        ClockRequest baseSocketRequest = new ClockRequest(mController.mConnectionController, mController.mAccountsController.getConnectionUrl(mBrandId), mBrandId);
        baseSocketRequest.addCallback(new ResponseCallback<GetClock.Response>() {
            @Override
            public void onSuccess(GetClock.Response data) {
                mCallback.onTaskSuccess();
            }

            @Override
            public void onError() {
                mCallback.onTaskError(SocketTaskType.GET_CLOCK, new Exception("get clock error"));
            }
        });
        SocketManager.getInstance().send(baseSocketRequest);
    }
}