package com.liveperson.messaging.model;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.commands.tasks.CloseConnectionTask;
import com.liveperson.messaging.commands.tasks.CollectSDKConfigurationDataTask;
import com.liveperson.messaging.commands.tasks.ConfigurationFetcherTask;
import com.liveperson.messaging.commands.tasks.CsdsTask;
import com.liveperson.messaging.commands.tasks.DataBaseTask;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.commands.tasks.LptagTask;
import com.liveperson.messaging.commands.tasks.OpenSocketTask;
import com.liveperson.messaging.commands.tasks.RemoveOlderImagesTask;
import com.liveperson.messaging.commands.tasks.SiteSettingsFetcherTask;

/**
 * Created by shiranr on 6/11/17.
 */

public class AmsConnectionAnalytics {

    protected static final String TAG = AmsConnectionAnalytics.class.getSimpleName();

    private static long mStartConnectingTime = 0;
    private static long mLastConnectingTime = 0;

	private static long mCsdsTaskStart = 0;
	private static long mCsdsTaskEnd = 0;
	private static long mLptagTaskStart = 0;
	private static long mLptagTaskEnd = 0;
	private static long mConfigurationFetcherTaskStart = 0;
	private static long mConfigurationFetcherTaskEnd = 0;
	private static long mSiteSettingsFetcherTaskStart = 0;
	private static long mSiteSettingsFetcherTaskEnd = 0;
	private static long mIdpTaskStart = 0;
	private static long mIdpTaskEnd = 0;
	private static long mRemoveOlderImagesTaskStart = 0;
	private static long mRemoveOlderImagesTaskEnd = 0;
	private static long mCollectSDKConfigurationDataTaskStart = 0;
	private static long mCollectSDKConfigurationDataTaskEnd = 0;
	private static long mDataBaseTaskStart = 0;
	private static long mDataBaseTaskEnd = 0;
	private static long mOpenSocketTaskStart = 0;
	private static long mOpenSocketTaskEnd = 0;
	private static long mCloseConnectionTaskStart = 0;
	private static long mCloseConnectionTaskEnd = 0;

    public static void startConnecting() {
        mStartConnectingTime = System.currentTimeMillis();
    }
	public static void startDisconnecting() {
		if (mStartConnectingTime > 0){
			LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN, "Disconnecting. tried to connect for " + (mStartConnectingTime -  System.currentTimeMillis()) + " millis");
			mStartConnectingTime = 0;
		}else{
			LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN, "Disconnecting. was connected for " + (System.currentTimeMillis() - mLastConnectingTime) + " millis");
			mLastConnectingTime = 0;
		}
	}

    public static void connected() {
		mLastConnectingTime = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN, "Connection time overall = " + (mLastConnectingTime - mStartConnectingTime) + " millis");
		mStartConnectingTime = 0;
	}

	public static void csdsTaskStart() {
		mCsdsTaskStart = System.currentTimeMillis();
	}

	public static void csdsTaskEnd() {
		mCsdsTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + CsdsTask.class.getSimpleName(), " task time = " + (mCsdsTaskEnd - mCsdsTaskStart) + " millis");
	}

	public static void lptagTaskStart() {
		mLptagTaskStart = System.currentTimeMillis();
	}

	public static void lptagTaskEnd() {
		mLptagTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN  + "_" + LptagTask.class.getSimpleName(), " task time = " + (mLptagTaskEnd - mLptagTaskStart) + " millis");
	}

	public static void configurationFetcherTaskStart() {
		mConfigurationFetcherTaskStart = System.currentTimeMillis();
	}

	public static void configurationFetcherTaskEnd() {
		mConfigurationFetcherTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + ConfigurationFetcherTask.class.getSimpleName(), " task time = " + (mConfigurationFetcherTaskEnd - mConfigurationFetcherTaskStart) + " millis");
	}

	public static void siteSettingsFetcherTaskStart() {
		mSiteSettingsFetcherTaskStart = System.currentTimeMillis();
	}

	public static void siteSettingsFetcherTaskEnd() {
		mSiteSettingsFetcherTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + SiteSettingsFetcherTask.class.getSimpleName(), " task time = " + (mSiteSettingsFetcherTaskEnd - mSiteSettingsFetcherTaskStart) + " millis");
	}

	public static void idpTaskStart() {
		mIdpTaskStart = System.currentTimeMillis();
	}

	public static void idpTaskEnd() {
		mIdpTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + IdpTask.class.getSimpleName(), " task time = " + (mIdpTaskEnd - mIdpTaskStart) + " millis");
	}

	public static void removeOlderImagesTaskStart() {
		mRemoveOlderImagesTaskStart = System.currentTimeMillis();
	}

	public static void removeOlderImagesTaskEnd() {
		mRemoveOlderImagesTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + RemoveOlderImagesTask.class.getSimpleName(), " task time = " + (mRemoveOlderImagesTaskEnd - mRemoveOlderImagesTaskStart) + " millis");
	}

	public static void databaseTaskStart() {
		mDataBaseTaskStart = System.currentTimeMillis();
	}

	public static void databaseTaskEnd() {
		mDataBaseTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + DataBaseTask.class.getSimpleName(), " task time = " + (mDataBaseTaskEnd - mDataBaseTaskStart) + " millis");
	}
	public static void collectSDKConfigurationDataTaskStart() {
		mCollectSDKConfigurationDataTaskStart = System.currentTimeMillis();
	}

	public static void collectSDKConfigurationDataTaskEnd() {
		mCollectSDKConfigurationDataTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + CollectSDKConfigurationDataTask.class.getSimpleName(), " task time = " + (mCollectSDKConfigurationDataTaskEnd - mCollectSDKConfigurationDataTaskStart) + " millis");
	}

	public static void openSocketTaskStart() {
		mOpenSocketTaskStart = System.currentTimeMillis();
	}

	public static void openSocketTaskEnd() {
		mOpenSocketTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + OpenSocketTask.class.getSimpleName(), " task time = " + (mOpenSocketTaskEnd - mOpenSocketTaskStart) + " millis");
	}

	public static void socketReady() {
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN + "_" + OpenSocketTask.class.getSimpleName(), " socket ready! time since socket opened: " + (System.currentTimeMillis() - mOpenSocketTaskEnd) );
	}

	public static void closeConnectionTaskStart() {
		mCloseConnectionTaskStart = System.currentTimeMillis();
	}

	public static void closeConnectionTaskEnd() {
		mCloseConnectionTaskEnd = System.currentTimeMillis();
		LPMobileLog.d(TAG, LPMobileLog.FlowTags.LOGIN  + "_" + CloseConnectionTask.class.getSimpleName(), " task time = " + (mCloseConnectionTaskEnd - mCloseConnectionTaskStart) + " millis");
	}


}
