package com.liveperson.messaging.model;


/**
 * Created by ofira on 04/01/2016.
 */
public class UserProfileBundle {

    private static final String TAG = UserProfileBundle.class.getSimpleName();
    private String mFirstName;
    private String mLastName;
    private String mPhoneNumber;
    private String mNickName;
    private String mAvatarUrl;

    private UserProfileBundle(Builder builder) {
        mFirstName = builder.firstName;
        mLastName = builder.lastName;
        mPhoneNumber = builder.phoneNumber;
        mNickName = builder.nickname;
        mAvatarUrl = builder.avatarUrl;
    }

    public String getFirstName() {
        return mFirstName;
    }

    public String getLastName() {
        return mLastName;
    }

    public String getPhoneNumber() {
        return mPhoneNumber;
    }

    public String getNickname() {
        return mNickName;
    }

    public String getAvatarUrl() {
        return mAvatarUrl;
    }

    public static class Builder {
        private String firstName;
        private String lastName;
        private String phoneNumber;
        private String nickname;
        private String avatarUrl;

        public UserProfileBundle build() {
            return new UserProfileBundle(this);
        }

        public Builder setFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder setLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder setNickname(String nickname) {
            this.nickname = nickname;
            return this;
        }

        public Builder setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }
    }
}
