package com.liveperson.messaging.network.http;

import android.net.Uri;

import com.liveperson.api.response.model.QueryParams;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpOpenStreamRequest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import okhttp3.Response;

public class DownloadFileRequest implements Command {

    private static final String TAG = "DownloadFileRequest";
    private static final int DOWNLOAD_IMAGE_TIMEOUT = 30000;
    private String mRelativePath;
    private QueryParams mQueryParams;
    private ICallback<byte[], Exception> mCallback;
    private String mDomain;
    private List<String> mCertificates;

    public DownloadFileRequest(String domain, String relativePath, QueryParams queryParams, List<String> certificates, ICallback<byte[], Exception> callback) {
        mRelativePath = relativePath;
        mQueryParams = queryParams;
        mCallback = callback;
        mDomain = domain;
        mCertificates = certificates;
    }


    /**
     * Execute request
     */
    @Override
    public void execute() {

        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https");
        builder.path(mDomain + mRelativePath);
        mQueryParams.appendQueryParameter(builder);

        HttpOpenStreamRequest httpGetRequest = new HttpOpenStreamRequest(builder.build().toString());
        httpGetRequest.setTimeout(DOWNLOAD_IMAGE_TIMEOUT);// TODO: 7/19/16 is this enough?
        httpGetRequest.setCertificatePinningKeys(mCertificates);
        LPMobileLog.d(TAG, "Downloading image from swift...");
        httpGetRequest.setCallback(new ICallback<Response, Exception>() {

            @Override
            public void onSuccess(Response response) {

                InputStream is = response.body().byteStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    int nRead;
                    LPMobileLog.d(TAG, "Downloading image from swift....  ");

                    /*16384 is a fairly arbitrary choice although I tend to favour powers of 2 to increase the chance of the array aligning with word boundaries.*/
                    byte[] data = new byte[16384];

                    while ((nRead = is.read(data, 0, data.length)) != -1) {
                        bos.write(data, 0, nRead);
                    }

                    bos.flush();

                    byte[] byteArray = bos.toByteArray();
                    LPMobileLog.d(TAG, "Downloading image from swift - byteArray.length  = " + byteArray.length);

                    mCallback.onSuccess(byteArray);

                } catch (IOException exception) {
                    mCallback.onError(exception);

                } finally {
                    try {
                        bos.close();
                    } catch (IOException ex) {
                        // ignore close exception
                    }
                }
            }

            @Override
            public void onError(Exception exception) {
                mCallback.onError(exception);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }


}
