package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.PublishEvent;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by shiranr on 17/11/2015.
 */
public class ChatStateChangeRequest extends BaseAMSSocketRequest<PublishEvent.Response, ChatStateChangeRequest> {
    private static final String TAG = ChatStateChangeRequest.class.getSimpleName();
    private String mDialogId;
    private String mConversationId;
    private PublishEvent.Type mType = PublishEvent.Type.ChatStateEvent;
    private ChatState mState;

    public ChatStateChangeRequest(String socketUrl, String dialogId, String conversationId, ChatState state) {
        super(socketUrl);
        mDialogId = dialogId;
        mConversationId = conversationId;
        mState = state;
    }

    @Override
    protected String getData() {
        return new PublishEvent(mDialogId, mConversationId, mType, mState).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<PublishEvent.Response, ChatStateChangeRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, ChatStateChangeRequest>() {

            @Override
            public String getAPIResponseType() {
                return PublishEvent.Response.PUBLISH_EVENT_RESPONSE_TYPE;
            }

            @Override
            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            @Override
            protected boolean handle(PublishEvent.Response response) {
                return true;
            }
        };
    }
}
