package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;

import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * An action that has a URL for link
 */
public class LinkAction extends BaseAction {

	public static final String TAG = LinkAction.class.getSimpleName();


	/**
	 * The link URI
	 */
	private String mUri;

	public LinkAction(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		// First try to get the "android" object from the json
		JSONObject androidObject = jsonObject.optJSONObject(ElementType.ANDROID);
		if (androidObject != null) { // Android object exist
			mUri = androidObject.getString(ElementType.URI);
		}
		else { // Android object does not exist. Use the default one
			mUri = jsonObject.getString(ElementType.URI);
		}
	}

	public LinkAction(String type, String name, String uri) {
		super(type, name);
		mUri = uri;
	}

	@Override
	public OnActionClickListener getOnClickListener(final Context context, final String brandId) {

		OnActionClickListener onClickListener = new OnActionClickListener() {
			@Override
			public void onClick() {

				if (!TextUtils.isEmpty(mUri)) {

					if (Configuration.getBoolean(R.bool.structured_content_link_as_callback)) {
						// Send the link as callback
						MessagingFactory.getInstance().getController().mEventsProxy.onStructuredContentLinkClicked(mUri);

					} else {
						// Send the link as deep link (startActivity)

						LPMobileLog.d(TAG, "onClick: activating link to: " + mUri);

						Intent i = new Intent(Intent.ACTION_VIEW, Uri.parse(mUri));
						// Check if we have an activity that can handle the intent
						PackageManager packageManager = context.getPackageManager();
						if (i.resolveActivity(packageManager) != null) {
							context.startActivity(i);
						}
						else{
							LPMobileLog.w(TAG, "onClick: no activity to handle the action (" + Uri.parse(mUri) + ")");
							// TODO: 4/19/17 callback to the host app with the error
						}
					}
				}
			}

		};

		return onClickListener;
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + "(" + "\n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {

	}

	public String getUri() {
		return mUri;
	}
}
