package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;

import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 6/6/17.
 */
public class PublishTextAction extends BaseAction {

	public static final String TAG = PublishTextAction.class.getSimpleName();

	private String mText;

	private JSONArray mMetadata;

	public PublishTextAction(JSONObject jsonObject, @Nullable JSONArray metadataJsonArray) throws JSONException {
		super(jsonObject);

		mText = jsonObject.getString(ElementType.TEXT);

		mMetadata = metadataJsonArray;
	}

	@Override
	public OnActionClickListener getOnClickListener(final Context context, final String brandId) {

		OnActionClickListener onClickListener = new OnActionClickListener() {
			@Override
			public void onClick() {
				// Send the text as a consumer message
				LPMobileLog.d(TAG, "onClick: sending text: " + mText + " with metadata: " + mMetadata);
				MessagingFactory.getInstance().getController().sendMessage(brandId, brandId, mText, new DeliveryStatusUpdateInfo(mMetadata));
			}
		};

		return onClickListener;

	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + "(" + "\n");

		return sb.toString();
	}


	@Override
	public void accept(ElementVisitor visitor) {

	}

}
