package com.liveperson.messaging.structuredcontent.model.elements;

import com.liveperson.messaging.structuredcontent.parsers.ElementType;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * This is the abstract base element for all elements that are not actions (basic and complex)
 * It includes the tooltip and rtl that are properties of all elements
 */
public abstract class SimpleElement extends BaseElement {

	/**
	 * The tooltip string
	 */
	protected String mTooltip;
	/**
	 * Right to left boolean property
	 */
	protected boolean mRtl;

	public SimpleElement(String type) {
		super(type);
	}

	public SimpleElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);

		// TODO: 4/2/17 test these
		mTooltip = jsonObject.optString(ElementType.TOOLTIP);
		mRtl = jsonObject.optBoolean(ElementType.RTL);
	}

	public String getTooltip() {
		return mTooltip;
	}

	public void setTooltip(String tooltip) {
		mTooltip = tooltip;
	}

	public boolean isRtl() {
		return mRtl;
	}

	public void setRtl(boolean rtl) {
		mRtl = rtl;
	}
}
