package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.SimpleElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Text element. Holds a string
 */
public class TextElement extends SimpleElement {

	private String mText;
	private ElementStyle mStyle;

	public TextElement() {
		super(ElementType.TEXT);
	}

	/**
	 * This sets text body from the given json.

	 * @param jsonObject
	 * @throws JSONException
	 */
	public TextElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mText = jsonObject.getString(ElementType.TEXT); // Mandatory
		JSONObject style = jsonObject.optJSONObject(ElementType.STYLE); //Optional
		mStyle = new ElementStyle(style);
	}


	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - " + mText + "\n");

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public void setText(String text) {
		mText = text;
	}

	public String getText() {
		return mText;
	}

	public ElementStyle getStyle() {
		return mStyle;
	}
}
