package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Image element. Holds the URL of the image (mandatory) and the image caption (not mandatory)
 */
public class WebViewElement extends ActionableElement {

	/**
	 * The URL of the image
	 */
	private String mUrl;



	public WebViewElement() {
		super(ElementType.WEBVIEW);
	}

	/**
	 * This sets text body from the given json.

	 * @param jsonObject
	 * @throws JSONException
	 */
	public WebViewElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mUrl = jsonObject.getString(ElementType.URL);
	}


	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " Url: " + mUrl);

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public String getUrl() {
		return mUrl;
	}

}
