package com.liveperson.messaging.structuredcontent.model.elements.complex;

import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 4/10/18.
 */
public class QuickRepliesElement extends ComplexElement {

	private int mItemsPerRow;

	public QuickRepliesElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject, ElementType.REPLIES);

		mItemsPerRow = jsonObject.optInt(ElementType.ITEMS_PER_ROW, 5);
	}

	@Override
	public void accept(ElementVisitor visitor) {

		visitor.visit(this);
	}

	@Override
	public String toString() {
		return null;
	}

	public int getItemsPerRow() {
		return mItemsPerRow;
	}
}
