/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.UploadImageTask;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.commands.ReSendImageCommand;
import com.liveperson.messaging.exception.FileSharingException;
import java.io.IOException;

public class ReUploadImageTask
extends UploadImageTask {
    private static final String TAG = ReUploadImageTask.class.getSimpleName();

    public ReUploadImageTask(ReUploadImageTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(params, uploadTimeout);
        this.mFileRowId = params.getFileRowId();
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)("imageTypeExtension = " + this.uploadImageTaskParams.getFileTypeExtension() + ", imageContentType = " + this.uploadImageTaskParams.getFileContentType()));
    }

    @Override
    protected Bitmap processOriginalImage(int orientation, boolean fromCamera) throws IOException, FileSharingException {
        Bitmap originalBitmap = ImageUtils.getBitmap((String)this.uploadImageTaskParams.getFilePath());
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)("originalBitmap size (w, h): " + originalBitmap.getWidth() + ", " + originalBitmap.getHeight()));
        return originalBitmap;
    }

    @Override
    @NonNull
    protected String saveOriginalImage(Bitmap originalBitmap) throws FileSharingException {
        this.createOriginalImageByteArray(originalBitmap, this.uploadImageTaskParams.getFileTypeExtension());
        return this.uploadImageTaskParams.getFilePath();
    }

    @Override
    protected Bitmap processThumbnailImage(int orientation, boolean fromCamera) throws IOException, FileSharingException {
        return ImageUtils.getBitmap((String)((ReUploadImageTaskBundle)this.uploadImageTaskParams).getThumbnailLocalPath());
    }

    @Override
    @NonNull
    protected String saveThumbnailImage(Bitmap thumbnailBitmap) throws FileSharingException {
        byte[] thumbnailByteArray = ImageUtils.getOutputStreamFromBitmap((Bitmap)thumbnailBitmap, (int)100, (String)this.uploadImageTaskParams.getFileTypeExtension());
        if (thumbnailByteArray == null) {
            return null;
        }
        this.mBase64 = ImageUtils.bitmapToBase64((byte[])thumbnailByteArray);
        LPMobileLog.d((String)(TAG + Thread.currentThread()), (String)("processThumbnailImage: Thumbnail Base64: " + this.mBase64));
        return ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getThumbnailLocalPath();
    }

    @Override
    protected void createSendMessageCommand(String thumbnailPath, String fullImagePath) {
        this.sendMessageCommand = new ReSendImageCommand(MessagingFactory.getInstance().getController(), this.uploadImageTaskParams.getTargetId(), this.uploadImageTaskParams.getBrandId(), this.uploadImageTaskParams.getFileContentType(), thumbnailPath, fullImagePath, this.uploadImageTaskParams.getFileTypeExtension(), ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getEventId(), this.uploadImageTaskParams.getMessage(), ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getOriginalMessageTime(), ((ReUploadImageTaskBundle)this.uploadImageTaskParams).getFileRowId());
        this.setSendMessageCommandCallback();
    }
}

