/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller.connection;

import com.liveperson.infra.Infra;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.commands.tasks.CloseConnectionTask;
import com.liveperson.messaging.commands.tasks.CollectSDKConfigurationDataTask;
import com.liveperson.messaging.commands.tasks.ConfigurationFetcherTask;
import com.liveperson.messaging.commands.tasks.CsdsTask;
import com.liveperson.messaging.commands.tasks.DataBaseTask;
import com.liveperson.messaging.commands.tasks.IdpTask;
import com.liveperson.messaging.commands.tasks.LptagTask;
import com.liveperson.messaging.commands.tasks.OpenSocketTask;
import com.liveperson.messaging.commands.tasks.RemoveOlderImagesTask;
import com.liveperson.messaging.commands.tasks.SiteSettingsFetcherTask;
import com.liveperson.messaging.commands.tasks.UnAuthGetEngagementTask;
import com.liveperson.messaging.controller.connection.DefaultTaskCallbackAmsAccount;
import com.liveperson.messaging.controller.connection.MessagingStateMachineInterface;
import java.util.ArrayList;
import java.util.List;

public class ConnectionTasksHolder {
    private final BaseAmsAccountConnectionTask mCsdsTask;
    private final BaseAmsAccountConnectionTask mLptagTask;
    private final BaseAmsAccountConnectionTask mConfigurationFetcherTask;
    private final BaseAmsAccountConnectionTask mSiteSettingsFetcherTask;
    private final BaseAmsAccountConnectionTask mIdpTask;
    private final BaseAmsAccountConnectionTask mUnAuthGetEngagementTask;
    private final BaseAmsAccountConnectionTask mRemoveOlderImagesTask;
    private final BaseAmsAccountConnectionTask mDataBaseTask;
    private final BaseAmsAccountConnectionTask mOpenSocketTask;
    private final BaseAmsAccountConnectionTask mCollectSDKConfigurationDataTask;
    private final BaseAmsAccountConnectionTask mCloseConnectionTask;
    private final IStateMachine mStateMachine;
    private final MessagingStateMachineInterface mController;
    private String mBrandId;
    private List<BaseAmsAccountConnectionTask> mPrimaryFullConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mPrimaryShortConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mSecondaryConnectingTasks;
    private List<BaseAmsAccountConnectionTask> mDisconnectingTasks;

    public ConnectionTasksHolder(IStateMachine stateMachine, MessagingStateMachineInterface messagingController, String brandId) {
        this.mStateMachine = stateMachine;
        this.mController = messagingController;
        this.mBrandId = brandId;
        String hostVersion = Infra.instance.getHostVersion();
        this.mCsdsTask = new CsdsTask(this.mController.getAccountsController());
        this.mCsdsTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mCsdsTask.getClass().getSimpleName()));
        this.mLptagTask = new LptagTask(this.mController.getAccountsController());
        this.mLptagTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mLptagTask.getClass().getSimpleName()));
        this.mConfigurationFetcherTask = new ConfigurationFetcherTask(this.mController.getAccountsController());
        this.mConfigurationFetcherTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mConfigurationFetcherTask.getClass().getSimpleName()));
        this.mSiteSettingsFetcherTask = new SiteSettingsFetcherTask(this.mController.getAccountsController());
        this.mSiteSettingsFetcherTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mSiteSettingsFetcherTask.getClass().getSimpleName()));
        this.mIdpTask = new IdpTask(this.mController.getAccountsController(), this.mController.getAmsUsers(), hostVersion);
        this.mIdpTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mIdpTask.getClass().getSimpleName()));
        this.mUnAuthGetEngagementTask = new UnAuthGetEngagementTask(this.mController.getAccountsController());
        this.mUnAuthGetEngagementTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mUnAuthGetEngagementTask.getClass().getSimpleName()));
        this.mRemoveOlderImagesTask = new RemoveOlderImagesTask(Infra.instance.getApplicationContext(), this.mBrandId, this.mBrandId);
        this.mRemoveOlderImagesTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mRemoveOlderImagesTask.getClass().getSimpleName()));
        this.mCollectSDKConfigurationDataTask = new CollectSDKConfigurationDataTask(Infra.instance.getApplicationContext());
        this.mCollectSDKConfigurationDataTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mCollectSDKConfigurationDataTask.getClass().getSimpleName()));
        this.mDataBaseTask = new DataBaseTask(this.mController.getAmsUsers(), this.mController.getAmsConversations(), this.mController.getAmsDialogs(), this.mController.getAmsMessages());
        this.mDataBaseTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mDataBaseTask.getClass().getSimpleName()));
        this.mOpenSocketTask = new OpenSocketTask(this.mController.getAccountsController(), this.mController.getConnectionController());
        this.mOpenSocketTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mOpenSocketTask.getClass().getSimpleName()));
        this.mCloseConnectionTask = new CloseConnectionTask(this.mController.getAccountsController());
        this.mCloseConnectionTask.setCallback(new DefaultTaskCallbackAmsAccount(this.mStateMachine, this.mCloseConnectionTask.getClass().getSimpleName()));
        this.mPrimaryFullConnectingTasks = this.constructPrimaryFullConnectionTasks();
        this.mPrimaryShortConnectingTasks = this.constructPrimaryShortConnectionTasks();
        this.mSecondaryConnectingTasks = this.constructSecondaryConnectionTasks();
        this.mDisconnectingTasks = this.constructDisconnectingTasks();
    }

    public List<BaseAmsAccountConnectionTask> constructPrimaryFullConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>(6);
        connectingTasks.add(this.mCsdsTask);
        connectingTasks.add(this.mLptagTask);
        connectingTasks.add(this.mConfigurationFetcherTask);
        connectingTasks.add(this.mSiteSettingsFetcherTask);
        connectingTasks.add(this.mDataBaseTask);
        connectingTasks.add(this.mUnAuthGetEngagementTask);
        connectingTasks.add(this.mIdpTask);
        connectingTasks.add(this.mRemoveOlderImagesTask);
        connectingTasks.add(this.mOpenSocketTask);
        return connectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> constructPrimaryShortConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>(3);
        connectingTasks.add(this.mDataBaseTask);
        connectingTasks.add(this.mUnAuthGetEngagementTask);
        connectingTasks.add(this.mIdpTask);
        connectingTasks.add(this.mOpenSocketTask);
        return connectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> constructSecondaryConnectionTasks() {
        ArrayList<BaseAmsAccountConnectionTask> connectingTasks = new ArrayList<BaseAmsAccountConnectionTask>(6);
        connectingTasks.add(this.mConfigurationFetcherTask);
        connectingTasks.add(this.mSiteSettingsFetcherTask);
        connectingTasks.add(this.mCsdsTask);
        connectingTasks.add(this.mRemoveOlderImagesTask);
        connectingTasks.add(this.mLptagTask);
        return connectingTasks;
    }

    private List<BaseAmsAccountConnectionTask> constructDisconnectingTasks() {
        ArrayList<BaseAmsAccountConnectionTask> disconnectingTasks = new ArrayList<BaseAmsAccountConnectionTask>(2);
        disconnectingTasks.add(this.mCloseConnectionTask);
        disconnectingTasks.add(this.mRemoveOlderImagesTask);
        return disconnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getPrimaryFullConnectionTasks(IStateMachine stateMachine) {
        return this.mPrimaryFullConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getPrimaryShortConnectionTasks(IStateMachine stateMachine) {
        return this.mPrimaryShortConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getSecondaryConnectionTasks(IStateMachine stateMachine) {
        return this.mSecondaryConnectingTasks;
    }

    public List<BaseAmsAccountConnectionTask> getDisconnectionTasks(IStateMachine stateMachine) {
        return this.mDisconnectingTasks;
    }
}

