/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import com.liveperson.api.exception.BadConversationException;
import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.infra.log.LPMobileLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class IncaGetConversationsListResponse {
    private static final String TAG = IncaGetConversationsListResponse.class.getSimpleName();
    public String mNextUrl;
    private int mCount = 0;
    private ArrayList<ConversationINCADetails> listOfConversations = null;

    public IncaGetConversationsListResponse(String response) {
        try {
            JSONObject responseJson = new JSONObject(response);
            JSONObject responseMetadataJson = responseJson.getJSONObject("_responseMetadata");
            this.mCount = responseMetadataJson.optInt("count");
            JSONObject next = responseMetadataJson.optJSONObject("next");
            if (next != null) {
                this.mNextUrl = next.optString("href");
            }
            JSONArray conversationList = responseJson.getJSONArray("conversationHistoryMetadataRecords");
            JSONObject conversation = null;
            this.listOfConversations = new ArrayList(conversationList.length());
            for (int i = 0; i < conversationList.length(); ++i) {
                conversation = conversationList.getJSONObject(i);
                try {
                    this.listOfConversations.add(new ConversationINCADetails(conversation));
                    continue;
                }
                catch (BadConversationException e) {
                    LPMobileLog.w((String)TAG, (String)e.getMessage());
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<ConversationINCADetails> getListOfConversations() {
        return this.listOfConversations;
    }

    public int getNumOfResults() {
        return this.mCount;
    }

    public String getUrlRef() {
        return this.mNextUrl;
    }
}

