package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendVoiceCommand extends SendVoiceCommand {

	public static final String TAG = "ReSendVoiceCommand";

	private long mFileRowId;
	private long mOriginalMessageTime;

	public ReSendVoiceCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, long fileRowId, long originalMessageTime, String previewContentType, String eventId) {
		super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message, previewContentType);
		mFileRowId = fileRowId;
		mOriginalMessageTime = originalMessageTime;
		mEventId = eventId;
	}

	@Override
	protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {

		mController.amsMessages.updateMessageState(mEventId,mTargetId,conversationId, MessagingChatMessage.MessageState.QUEUED);
		mController.amsMessages.getRowIdByEventId(mEventId).setPostQueryOnBackground(new DataBaseCommand.QueryCallback<Long>() {
			@Override
			public void onResult(Long data) {
				mMessageRowId = data;
				if (mCallback != null) {
					mCallback.onFileAddedToDB(mMessageRowId,mFileRowId);
				}
			}
		}).execute();
	}

	@Override
	protected long getMessageTime() {
		return mOriginalMessageTime;
	}

}
