package com.liveperson.messaging.commands;

import com.liveperson.api.request.GenerateUploadTokenRequest;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;


/**
 * Created by Maayan on 9/3/2017
 * A command for generating token for secure form
 */
public class SendGenerateUploadTokenCommand implements Command {

	private static final String TAG = "SendGenUploadTokenCmd";

	private String mDialogId;
	private String mFormId;
	private String mInvitationId;
	private String mSocketUrl;
	private ICallback mCallback;


	/**
	 * Creates a command for sending messages
	 */
	public SendGenerateUploadTokenCommand(String socketUrl,
										  String formId,
										  String dialogId,
										  String invitationId,
										  ICallback callback) {

		mSocketUrl = socketUrl;
		mDialogId = dialogId;
		mFormId = formId;
		mInvitationId = invitationId;
		mCallback = callback;
	}

	@Override
	public void execute() {
		GenerateUploadTokenRequest baseSocketRequest = new GenerateUploadTokenRequest(mSocketUrl, mDialogId, mFormId, mInvitationId);
		baseSocketRequest.setResponseCallBack(new ICallback() {
			@Override
			public void onSuccess(Object value) {
				mCallback.onSuccess(value);
				LPMobileLog.d(TAG, "onSuccess with value: "+value);
			}

			@Override
			public void onError(Throwable exception) {
				LPMobileLog.w(TAG, "an error in parsing");
				mCallback.onError(exception);
			}
		});
		SocketManager.getInstance().send(baseSocketRequest);
	}
}
