package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.api.request.BaseAMSSocketRequest;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

/**
 * Created by Eyal Vites on 11/20/2015.
 */
public class DeliveryStatusUpdateRequest extends BaseAMSSocketRequest<PublishEvent.Response, DeliveryStatusUpdateRequest> {

    private static final String TAG = DeliveryStatusUpdateRequest.class.getSimpleName();

    private String mDialogId;
    private String mConversationId;
    private DeliveryStatus status;
    private PublishEvent.Type type = PublishEvent.Type.AcceptStatusEvent;
    List<Integer> sequenceList;
    private DeliveryStatusUpdateInfo mInfo = null;

    public DeliveryStatusUpdateRequest(String socketUrl, String dialogId, String conversationId, DeliveryStatus status, List<Integer> sequenceList) {
        super(socketUrl);
        this.mDialogId = dialogId;
        this.mConversationId = conversationId;
        this.status = status;
        this.sequenceList = sequenceList;
    }

    public void setInfo(DeliveryStatusUpdateInfo info){
        mInfo = info;
    }

    @Override
    protected String getData() {
        int[] sequenceArray = new int[sequenceList.size()];
        int i = 0;
        for (Integer seq : sequenceList) {
            sequenceArray[i++] = seq;
        }
        return new PublishEvent(mDialogId, mConversationId, type, status.name(), sequenceArray, mInfo).toJsonString(getRequestId());
    }

    @Override
    protected String getRequestName() {
        return TAG;
    }

    @Override
    protected BaseResponseHandler<PublishEvent.Response, DeliveryStatusUpdateRequest> getResponseHandler() {
        return new BaseResponseHandler<PublishEvent.Response, DeliveryStatusUpdateRequest>() {
            @Override
            public String getAPIResponseType() {
                return PublishEvent.Response.PUBLISH_EVENT_RESPONSE_TYPE;
            }

            @Override
            protected PublishEvent.Response parse(JSONObject jsonObject) throws JSONException {
                return new PublishEvent.Response(jsonObject);
            }

            @Override
            protected boolean handle(PublishEvent.Response data) {
                //The handling is in OnlineEventDistribution
                return true;
            }
        };
    }
}
