package com.liveperson.messaging.network.socket.requests;

import com.liveperson.api.request.PublishEvent;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.request.message.FormSubmissionPublishMessage;
import com.liveperson.api.request.message.PublishMessage;
import com.liveperson.messaging.Messaging;

/**
 * Created by Ilya Gazman on 11/10/2015.
 * <p/>
 * A request to send message
 */
public class SendFormSubmissionMessageRequest extends SendMessageRequest {

	private static final String TAG = SendFormSubmissionMessageRequest.class.getSimpleName();

	private final String mTargetId;
	private final String mBrandId;
	private final String mEventId;
	private String mInvitationId;
	private String mSubmissionId;
	private String mDialogId;
	private String mConversationId;
	protected PublishMessage mMessage;
	private PublishEvent.Type mType = PublishEvent.Type.ContentEvent;
	private ContentType mContentType = ContentType.forms_secure_submission;
	private Messaging mController;

	/**
	 * This constructor gets the requestId as one of its parameters and override with it the request's one
	 *
	 * @param brandId
	 * @param dialogId
	 * @param conversationId
	 * @param msg
	 */
	public SendFormSubmissionMessageRequest(Messaging controller, String eventId, String targetId,
											String brandId, String dialogId, String conversationId, String msg,
											String invitationId, String submissionId) {
		super(controller, eventId, targetId, brandId, dialogId, conversationId);
		mController = controller;
		mDialogId = dialogId;
		mConversationId = conversationId;
		mTargetId = targetId;
		mBrandId = brandId;
		mEventId = eventId;
		mInvitationId = invitationId;
		mSubmissionId = submissionId;
		mMessage = new FormSubmissionPublishMessage(mInvitationId, mSubmissionId);
	}

	public void setMessageContent(String msg) {
		mMessage = new FormSubmissionPublishMessage(mInvitationId, mSubmissionId);
	}

	@Override
	protected String getData() {
		return new PublishEvent(mDialogId, mConversationId, mMessage, mType, mContentType, mEventId, null).toJsonString(getRequestId());
	}

	@Override
	protected String getRequestName() {
		return TAG;
	}

}