/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import com.liveperson.api.exception.BadMessageException;
import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.response.AbstractResponse;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.infra.log.LPMobileLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryMessages
extends AbstractRequest {
    public static final String DIALOG_ID = "dialogId";
    public static final String MAX_QUANTITY = "maxQuantity";
    public static final String OLDER_THAN_SEQUENCE = "olderThanSequence";
    public static final String NEWER_THAN_SEQUENCE = "newerThanSequence";
    public static final String SEQUENCE = "sequence";
    public static final String ORIGINATOR_ID = "originatorId";
    public static final String SERVER_TIMESTAMP = "serverTimestamp";
    public static final String EVENT = "event";
    public static final String SEQUENCE1 = "sequence";
    public static final String BODY = "body";
    private static final String QUERY_MESSAGES_TYPE = ".ams.ms.QueryMessages";
    public String dialogId;
    public int maxQuantity;
    public long olderThanSequence;
    public long newerThanSequence;

    public QueryMessages(String dId, int maxQ, long olderThan, long newerThan) {
        this.dialogId = dId;
        this.maxQuantity = maxQ;
        this.olderThanSequence = olderThan;
        this.newerThanSequence = newerThan;
    }

    @Override
    public String getMessageType() {
        return QUERY_MESSAGES_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        this.body.put(DIALOG_ID, (Object)this.dialogId);
        if (this.maxQuantity != -1) {
            this.body.put(MAX_QUANTITY, this.maxQuantity);
        }
        if (this.olderThanSequence != -1L) {
            this.body.put(OLDER_THAN_SEQUENCE, this.olderThanSequence);
        }
        this.body.put(NEWER_THAN_SEQUENCE, this.newerThanSequence);
        json.put(BODY, (Object)this.body);
    }

    public static class Response
    extends AbstractResponse {
        public static final String QUERY_MESSAGES_RESPONSE_TYPE = ".ams.ms.QueryMessages$Response";
        private static final String TAG = "QueryMessagesResponse";
        ArrayList<ContentEventNotification> body;

        public Response(JSONObject obj) throws JSONException {
            super(obj);
            JSONArray bodyArr = obj.getJSONArray(QueryMessages.BODY);
            this.parseContent(bodyArr);
        }

        public Response(JSONArray obj) throws JSONException {
            super(null);
            this.parseContent(obj);
        }

        private void parseContent(JSONArray bodyArr) throws JSONException {
            this.body = new ArrayList(bodyArr.length());
            for (int i = 0; i < bodyArr.length(); ++i) {
                try {
                    this.body.add(new ContentEventNotification(bodyArr.getJSONObject(i)));
                    continue;
                }
                catch (BadMessageException e) {
                    LPMobileLog.w((String)TAG, (String)("Bad message: " + e.getMessage()));
                }
            }
        }

        public ArrayList<ContentEventNotification> getBody() {
            return this.body;
        }
    }
}

