/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request.message;

import com.liveperson.api.request.message.BasePublishMessage;
import com.liveperson.infra.log.LPMobileLog;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonPublishMessage
extends BasePublishMessage {
    private static final String TAG = JsonPublishMessage.class.getCanonicalName();
    private static final String KEY_JSON_TAG_TITLE = "title";
    private static final String KEY_JSON_TAG_DESCRIPTION = "description";
    private static final String KEY_JSON_HEADER = "message_with_url";
    private static final String KEY_JSON_TAG_IMAGE_URL = "image_url";
    private static final String KEY_JSON_TAG_MESSAGE = "original_message";
    private static final String KEY_JSON_TAG_URL = "original_url_to_parse";
    private static final String KEY_JSON_TAG_SITE_NAME = "site_name_url_to_parse";
    private String mCaption;
    private String mTitle;
    private String mDescription;
    private String mCurrentImageURL;
    private String mCurrentUrl;
    private String mSiteName;

    public JsonPublishMessage(String originalMsg, String url) {
        this.mCaption = originalMsg.trim();
        this.mCurrentUrl = url.trim();
    }

    public JsonPublishMessage(JSONObject jsonObject) {
        this.mTitle = jsonObject.optString(KEY_JSON_TAG_TITLE);
        this.mDescription = jsonObject.optString(KEY_JSON_TAG_DESCRIPTION);
        this.mCurrentImageURL = jsonObject.optString(KEY_JSON_TAG_IMAGE_URL);
        this.mCaption = jsonObject.optString(KEY_JSON_TAG_MESSAGE);
        this.mCurrentUrl = jsonObject.optString(KEY_JSON_TAG_URL);
        this.mSiteName = jsonObject.optString(KEY_JSON_TAG_SITE_NAME);
    }

    @Override
    public String getMessage() {
        JSONObject msgJson = new JSONObject();
        try {
            msgJson.put(KEY_JSON_TAG_TITLE, (Object)this.mTitle);
            msgJson.put(KEY_JSON_TAG_DESCRIPTION, (Object)this.mDescription);
            msgJson.put(KEY_JSON_TAG_IMAGE_URL, (Object)this.mCurrentImageURL);
            msgJson.put(KEY_JSON_TAG_MESSAGE, (Object)this.mCaption);
            msgJson.put(KEY_JSON_TAG_URL, (Object)this.mCurrentUrl);
            msgJson.put(KEY_JSON_TAG_SITE_NAME, (Object)this.mSiteName);
        }
        catch (JSONException e) {
            LPMobileLog.d((String)TAG, (String)"getMessage - Can't create URL message:");
        }
        return msgJson.toString();
    }

    @Override
    public BasePublishMessage.PublishMessageType getType() {
        return BasePublishMessage.PublishMessageType.JSON;
    }

    @Override
    public String getMessageText() {
        return this.getMessageTextWithoutSpecialChars(this.mCaption);
    }

    public String getCaption() {
        return this.mCaption;
    }
}

