/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.types;

import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.infra.log.LPMobileLog;
import org.json.JSONObject;

public class CSAT {
    public int csatRate = -1;
    public String csatResolutionConfirmation;
    public CsatStatus csatStatus;
    private CSAT_SHOW_STATUS showedCsat = CSAT_SHOW_STATUS.NO_VALUE;

    public CSAT(JSONObject jsonObject) {
        JSONObject csatObject = jsonObject.optJSONObject("csat");
        if (csatObject != null && !jsonObject.isNull("csat")) {
            this.csatRate = csatObject.isNull("csatRate") ? -1 : csatObject.optInt("csatRate", -1);
            this.csatResolutionConfirmation = csatObject.isNull("csatResolutionConfirmation") ? null : csatObject.optString("csatResolutionConfirmation", null);
            String status = csatObject.isNull("status") ? null : csatObject.optString("status", null);
            this.csatStatus = CsatStatus.get(status);
        }
        this.calculateCsatShown();
    }

    private void calculateCsatShown() {
        this.showedCsat = this.csatRate > 0 || this.csatStatus == CsatStatus.SKIPPED || this.csatResolutionConfirmation != null ? CSAT_SHOW_STATUS.SHOWN : CSAT_SHOW_STATUS.NOT_SHOWN;
    }

    public CSAT_SHOW_STATUS isShowedCsat() {
        LPMobileLog.d((String)"CsatStatus", (String)("CSAT state = " + this.showedCsat.name()));
        return this.showedCsat;
    }

    public static enum CSAT_SHOW_STATUS {
        NO_VALUE(-1),
        NOT_SHOWN(0),
        SHOWN(1),
        NO_NEED_TO_SHOW(2);

        private final int csatValue;

        private CSAT_SHOW_STATUS(int value) {
            this.csatValue = value;
        }

        public int getValue() {
            return this.csatValue;
        }

        public static CSAT_SHOW_STATUS parse(int intValue) {
            for (CSAT_SHOW_STATUS csat : CSAT_SHOW_STATUS.values()) {
                if (csat.csatValue != intValue) continue;
                return csat;
            }
            return NO_VALUE;
        }
    }
}

