/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import com.liveperson.api.response.events.ExConversationChangeNotification;
import com.liveperson.api.response.events.MessagingEventNotification;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.messaging.Messaging;

public class GeneralMessagingResponseHandler
extends GeneralResponseHandler {
    private static final String TAG = GeneralMessagingResponseHandler.class.getSimpleName();
    private final Messaging mController;

    GeneralMessagingResponseHandler(Messaging controller) {
        this.mController = controller;
    }

    protected BaseResponseHandler createInstance(String responseType) {
        if (responseType.equals(ExConversationChangeNotification.getType())) {
            LPMobileLog.d((String)("FLOW_RESPONSES_" + TAG), (String)("Creating general response - ExConversationChangeNotification - for message type :" + responseType));
            return ExConversationChangeNotification.getResponseHandler(this.mController);
        }
        if (responseType.equals(MessagingEventNotification.Companion.getType())) {
            LPMobileLog.d((String)("FLOW_RESPONSES_" + TAG), (String)("Creating general response - MessagingEventNotification - for message type :" + responseType));
            return MessagingEventNotification.Companion.getResponseHandler(this.mController);
        }
        LPMobileLog.e((String)("FLOW_RESPONSES_" + TAG), (String)("Couldn't find general response for message type :" + responseType));
        return null;
    }
}

