/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.LivePersonIntents;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.Infra;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.model.AgentData;

public class LivePersonEventsProxy
implements LivePersonCallback {
    private LivePersonCallback mCallback = new LivePersonCallback.NullLivePersonCallback();

    LivePersonEventsProxy() {
    }

    public void setCallback(LivePersonCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void removeCallback() {
        this.mCallback = new LivePersonCallback.NullLivePersonCallback();
    }

    @Override
    public void onError(TaskType type, String message) {
        Infra.instance.getApplicationHandler().post(() -> {
            this.mCallback.onError(type, message);
            LivePersonIntents.sendOnErrorIntent(Infra.instance.getApplicationContext(), type, message);
        });
    }

    @Override
    public void onTokenExpired() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onTokenExpired();
            LivePersonIntents.sendOnTokenExpired(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onUnauthenticatedUserExpired() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onUnauthenticatedUserExpired();
            LivePersonIntents.sendOnUserExpired(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onConversationStarted(LPConversationData convData) {
        Infra.instance.getApplicationHandler().post(() -> {
            this.mCallback.onConversationStarted();
            this.mCallback.onConversationStarted(convData);
            LivePersonIntents.sendOnConversationStarted(Infra.instance.getApplicationContext(), convData);
        });
    }

    @Override
    @Deprecated
    public void onConversationStarted() {
        this.mCallback.onConversationStarted();
    }

    @Override
    public void onConversationResolved(LPConversationData convData) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onConversationResolved();
            this.mCallback.onConversationResolved(convData.getCloseReason());
            this.mCallback.onConversationResolved(convData);
            LivePersonIntents.sendOnConversationResolved(Infra.instance.getApplicationContext(), convData);
        });
    }

    @Override
    @Deprecated
    public void onConversationResolved() {
        this.mCallback.onConversationResolved();
    }

    @Override
    @Deprecated
    public void onConversationResolved(CloseReason reason) {
        this.mCallback.onConversationResolved(reason);
    }

    @Override
    public void onConversationFragmentClosed() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onConversationFragmentClosed();
            LivePersonIntents.sendOnConversationFragmentClosed(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onConnectionChanged(boolean isConnected) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onConnectionChanged(isConnected);
            LivePersonIntents.sendOnConnectionChanged(Infra.instance.getApplicationContext(), isConnected);
        });
    }

    @Override
    public void onAgentTyping(boolean isTyping) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onAgentTyping(isTyping);
            LivePersonIntents.sendOnAgentTyping(Infra.instance.getApplicationContext(), isTyping);
        });
    }

    @Override
    public void onAgentDetailsChanged(AgentData agentData) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onAgentDetailsChanged(agentData);
            LivePersonIntents.sendOnAgentDetailsChanged(Infra.instance.getApplicationContext(), agentData);
        });
    }

    @Override
    public void onCsatLaunched() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onCsatLaunched();
            LivePersonIntents.sendOnCsatLaunched(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onCsatDismissed() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onCsatDismissed();
            LivePersonIntents.sendOnCsatDismissed(Infra.instance.getApplicationContext());
        });
    }

    @Override
    @Deprecated
    public void onCsatSubmitted(String conversationId) {
        this.mCallback.onCsatSubmitted(conversationId);
    }

    @Override
    public void onCsatSubmitted(String conversationId, int starRating) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onCsatSubmitted(conversationId);
            this.mCallback.onCsatSubmitted(conversationId, starRating);
            LivePersonIntents.sendOnCsatSubmitted(Infra.instance.getApplicationContext(), conversationId, starRating);
        });
    }

    @Override
    public void onCsatSkipped() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onCsatSkipped();
            LivePersonIntents.sendOnCsatSkipped(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onConversationMarkedAsUrgent() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onConversationMarkedAsUrgent();
            LivePersonIntents.sendOnConversationMarkedAsUrgent(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onConversationMarkedAsNormal() {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onConversationMarkedAsNormal();
            LivePersonIntents.sendOnConversationMarkedAsNormal(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onOfflineHoursChanges(boolean isOfflineHoursOn) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onOfflineHoursChanges(isOfflineHoursOn);
            LivePersonIntents.sendOnOfflineHoursChanges(Infra.instance.getApplicationContext(), isOfflineHoursOn);
        });
    }

    @Override
    public void onAgentAvatarTapped(AgentData agentData) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onAgentAvatarTapped(agentData);
            LivePersonIntents.sendOnAgentAvatarTapped(Infra.instance.getApplicationContext(), agentData);
        });
    }

    @Override
    public void onUserDeniedPermission(PermissionType permissionType, boolean doNotShowAgainMarked) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onUserDeniedPermission(permissionType, doNotShowAgainMarked);
            LivePersonIntents.sendOnUserDeniedPermission(Infra.instance.getApplicationContext(), permissionType, doNotShowAgainMarked);
        });
    }

    @Override
    public void onUserActionOnPreventedPermission(PermissionType permissionType) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onUserActionOnPreventedPermission(permissionType);
            LivePersonIntents.sendOnUserActionOnPreventedPermission(Infra.instance.getApplicationContext(), permissionType);
        });
    }

    @Override
    public void onStructuredContentLinkClicked(String uri) {
        Infra.instance.postOnMainThread(() -> {
            this.mCallback.onStructuredContentLinkClicked(uri);
            LivePersonIntents.sendOnStructuredContentLinkClicked(Infra.instance.getApplicationContext(), uri);
        });
    }
}

