/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.image;

import android.content.Context;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.background.filesharing.image.UploadImageTaskBundle;

public class ReUploadImageTaskBundle
extends UploadImageTaskBundle {
    private static final String TAG = ReUploadImageTaskBundle.class.getSimpleName();
    private String thumbnailLocalPath;
    private String eventId;
    private long originalMessageTime;
    private long fileRowId;

    @Override
    public ReUploadImageTaskBundle build(int taskId, Context context) {
        this.setTaskID(taskId);
        this.mFileTypeExtension = MimeTypeMap.getFileExtensionFromUrl((String)this.mFilePath).toUpperCase();
        this.mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.mFileTypeExtension.toLowerCase());
        LPMobileLog.d((String)TAG, (String)("build: mImageUri: " + this.mFileUri + " mImageTypeExtension = " + this.mFileTypeExtension + " mImageContentType = " + this.mFileContentType));
        return this;
    }

    public String getThumbnailLocalPath() {
        return this.thumbnailLocalPath;
    }

    public String getEventId() {
        return this.eventId;
    }

    public long getOriginalMessageTime() {
        return this.originalMessageTime;
    }

    public long getFileRowId() {
        return this.fileRowId;
    }

    public ReUploadImageTaskBundle addFileRowId(long fileRowId) {
        this.fileRowId = fileRowId;
        return this;
    }

    public ReUploadImageTaskBundle addThumbnailLocalPath(String thumbnailLocalUriPath) {
        this.thumbnailLocalPath = thumbnailLocalUriPath;
        return this;
    }

    public ReUploadImageTaskBundle addEventID(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public ReUploadImageTaskBundle addOriginalMessageTime(long originalMessageTime) {
        this.originalMessageTime = originalMessageTime;
        return this;
    }

    public ReUploadImageTaskBundle addOriginalLocalPath(String originalImagePath) {
        this.mFilePath = originalImagePath;
        return this;
    }
}

