/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.GetUnreadMessagesCountCommand;
import com.liveperson.messaging.commands.GetUnreadMessagesCountFromUMSCommand;
import org.json.JSONObject;

public class GetCombinedUnreadMessagesCountCommand
implements Command {
    public static final String TAG = "GetCombinedUnreadMessagesCountCommand";
    private Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mAppId;
    private static boolean isRegisteredToPusher = true;

    public GetCombinedUnreadMessagesCountCommand(Messaging messagingController, String brandId, String appId, ICallback<Integer, Exception> callback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.mCallback = callback;
    }

    public void execute() {
        if (isRegisteredToPusher) {
            LPMobileLog.d((String)TAG, (String)"Getting unread count!!!!! from pusher");
            this.getUnreadMessageCountFromPusher();
        } else {
            LPMobileLog.d((String)TAG, (String)"Getting unread count!!!!! from ums");
            this.getUnreadMessageCountFromUMS();
        }
    }

    private void getUnreadMessageCountFromPusher() {
        new GetUnreadMessagesCountCommand(this.mController, this.mBrandId, this.mAppId, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                LPMobileLog.d((String)GetCombinedUnreadMessagesCountCommand.TAG, (String)("Pusher returned error: " + exception));
                if (exception != null) {
                    try {
                        String mess = GetCombinedUnreadMessagesCountCommand.this.parseException(exception.getMessage());
                        JSONObject error = new JSONObject(mess);
                        String errorString = error.getString("error");
                        if (!TextUtils.isEmpty((CharSequence)errorString)) {
                            JSONObject errorBody = new JSONObject(errorString);
                            String statusCode = errorBody.getString("statusCode");
                            String internalCode = errorBody.getString("internalCode");
                            if (statusCode.equals("404") && internalCode.equals("16")) {
                                GetCombinedUnreadMessagesCountCommand.setIsRegisteredToPusher(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        LPMobileLog.e((String)GetCombinedUnreadMessagesCountCommand.TAG, (String)("Failed to parse unread message count exception from pusher: " + e));
                    }
                    GetCombinedUnreadMessagesCountCommand.this.getUnreadMessageCountFromUMS();
                }
            }
        }).execute();
    }

    private void getUnreadMessageCountFromUMS() {
        new GetUnreadMessagesCountFromUMSCommand(this.mController, this.mBrandId, new ICallback<Integer, Exception>(){

            public void onSuccess(Integer value) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onSuccess((Object)value);
            }

            public void onError(Exception exception) {
                GetCombinedUnreadMessagesCountCommand.this.mCallback.onError((Throwable)exception);
            }
        }).execute();
    }

    private String parseException(String exception) {
        return exception.substring(exception.indexOf(123));
    }

    public static void setIsRegisteredToPusher(boolean value) {
        isRegisteredToPusher = value;
    }
}

