/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import com.liveperson.messaging.utils.TokenUtils;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;

public class GetUnreadMessagesCountFromUMSCommand
implements Command {
    public static final String TAG = "GetUnreadMessagesCountCommand";
    private static final String UMS_UNREAD_COUNT_URL = "https://%s/api/account/%s/messaging/consumer/conversation/unread-messages-count?v=3";
    public static final String AUTHORIZATION = "Authorization";
    private static final String USER_AGENT = "User-Agent";
    private static final String ANDROID = "ANDROID";
    private static final String ERROR_UNABLE_TO_MAKE_REQUEST = "Unable to make request.";
    private static final String ERROR_SERVER_ERROR = "Server error: ";
    private static final String UNREAD_COUNT = "unread_count";
    private static final String UNREAD_REQUEST_TIMESTAMP = "unread_request_timestamp";
    private static final long LAST_REQUEST_TIMESTAMP_THRESHOLD = 10000L;
    private static final int REQUEST_TIMEOUT = 30000;
    private final Messaging mController;
    private String mBrandId;
    private ICallback<Integer, Exception> mCallback;
    private String mUmsDomain;
    private PreferenceManager mPreferenceManager;
    private String mLocalToken;

    public GetUnreadMessagesCountFromUMSCommand(Messaging messagingController, String brandId, ICallback<Integer, Exception> callback) {
        this.mController = messagingController;
        this.mBrandId = brandId;
        this.mCallback = callback;
        this.mPreferenceManager = PreferenceManager.getInstance();
    }

    public void execute() {
        if (!this.isRequestThresholdWasPassed(this.mBrandId)) {
            LPMobileLog.d((String)TAG, (String)"Time threshold was not passed yet. Return cached value of unread Messages");
            this.returnCachedDetails();
        } else {
            LPMobileLog.d((String)TAG, (String)"Time threshold was passed. Make getUnreadMessageCount request");
            if (this.mController.mAccountsController.getAccount(this.mBrandId) == null) {
                this.mLocalToken = this.getTokenFromSharedPreferences();
                if (TokenUtils.isJwtExpired(this.mLocalToken)) {
                    this.sendTokenExpired();
                    return;
                }
            } else if (this.mController.mAccountsController.isTokenExpired(this.mBrandId)) {
                this.sendTokenExpired();
                return;
            }
            LPMobileLog.d((String)TAG, (String)"JWT is valid - send request to get unread message count");
            this.mUmsDomain = this.mController.mAccountsController.getServiceUrl(this.mBrandId, "asyncMessagingEnt");
            if (TextUtils.isEmpty((CharSequence)this.mUmsDomain)) {
                this.mUmsDomain = PreferenceManager.getInstance().getStringValue("asyncMessagingEnt", this.mBrandId, null);
                if (TextUtils.isEmpty((CharSequence)this.mUmsDomain)) {
                    this.notifyError(new Exception("Unable to make request. Error: Missing Domain"));
                    return;
                }
            }
            this.validateStateAndSendRequest(this.mUmsDomain);
        }
    }

    private String getTokenFromSharedPreferences() {
        String token;
        String decryptedToken = this.mPreferenceManager.getStringValue("account_token_enc", this.mBrandId, null);
        if (TextUtils.isEmpty((CharSequence)decryptedToken)) {
            token = this.mPreferenceManager.getStringValue("account_token", this.mBrandId, null);
            this.mPreferenceManager.remove("account_token", this.mBrandId);
        } else {
            token = DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)decryptedToken);
        }
        return token;
    }

    private void sendTokenExpired() {
        LPMobileLog.d((String)TAG, (String)"JWT is expired - calling to onTokenExpired callback");
        this.mController.mEventsProxy.onTokenExpired();
        this.mCallback.onError((Throwable)new Exception("Unable to make request. Error: Token expired, refresh the token and try again"));
    }

    private void notifySuccess(final int counter) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    GetUnreadMessagesCountFromUMSCommand.this.mCallback.onSuccess((Object)counter);
                }
            });
        }
    }

    private void notifyError(final Exception exception) {
        if (this.mCallback != null) {
            Infra.instance.postOnMainThread(new Runnable(){

                @Override
                public void run() {
                    if (exception instanceof SSLPeerUnverifiedException) {
                        ((GetUnreadMessagesCountFromUMSCommand)GetUnreadMessagesCountFromUMSCommand.this).mController.mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, exception.getMessage());
                    }
                    GetUnreadMessagesCountFromUMSCommand.this.mCallback.onError((Throwable)exception);
                }
            });
        }
    }

    private void validateStateAndSendRequest(final String umsDomain) {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.sendRequest(umsDomain);
        } else {
            new SynchronizedInternetConnectionCallback(new Runnable(){

                @Override
                public void run() {
                    GetUnreadMessagesCountFromUMSCommand.this.sendRequest(umsDomain);
                }
            }).execute();
        }
    }

    private String buildRequestURL(String umsDomain) {
        return String.format(UMS_UNREAD_COUNT_URL, umsDomain, this.mBrandId);
    }

    private void sendRequest(String requestURL) {
        requestURL = this.buildRequestURL(requestURL);
        String token = this.mController.mAccountsController.getToken(this.mBrandId);
        String string2 = token = token == null ? this.mLocalToken : token;
        if (token == null || requestURL == null) {
            this.notifyError(new Exception("Unable to make request. Error: Authorization failed. Token is missing or is invalid"));
            return;
        }
        List<String> certificates = this.mController.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        HttpGetRequest httpGetRequest = new HttpGetRequest(requestURL);
        httpGetRequest.addHeader(AUTHORIZATION, token);
        httpGetRequest.addHeader(USER_AGENT, ANDROID);
        httpGetRequest.setCertificatePinningKeys(certificates);
        httpGetRequest.setTimeout(30000);
        LPMobileLog.i((String)TAG, (String)("GetUnreadMessageCount url " + requestURL));
        httpGetRequest.setCallback((ICallback)new ICallback<String, Exception>(){

            public void onSuccess(String count) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)count)) {
                        LPMobileLog.i((String)GetUnreadMessagesCountFromUMSCommand.TAG, (String)("onSuccess " + count));
                        if (GetUnreadMessagesCountFromUMSCommand.this.mCallback != null) {
                            int unreadCount = Integer.parseInt(count);
                            GetUnreadMessagesCountFromUMSCommand.this.updateCachedDetails(unreadCount);
                            GetUnreadMessagesCountFromUMSCommand.this.notifySuccess(unreadCount);
                            return;
                        }
                    }
                    GetUnreadMessagesCountFromUMSCommand.this.notifyError(new Exception("Server error: Empty response"));
                }
                catch (Exception error) {
                    LPMobileLog.e((String)GetUnreadMessagesCountFromUMSCommand.TAG, (String)("Failed to parse unread message count: " + error));
                    GetUnreadMessagesCountFromUMSCommand.this.notifyError(error);
                }
            }

            public void onError(Exception exception) {
                if (exception != null) {
                    LPMobileLog.e((String)GetUnreadMessagesCountFromUMSCommand.TAG, (String)("onError " + exception.getMessage()));
                    if (GetUnreadMessagesCountFromUMSCommand.this.mCallback != null) {
                        GetUnreadMessagesCountFromUMSCommand.this.notifyError(new Exception(GetUnreadMessagesCountFromUMSCommand.ERROR_SERVER_ERROR + exception.getMessage()));
                    }
                }
            }
        });
        HttpHandler.execute((HttpRequest)httpGetRequest);
    }

    private void updateCachedDetails(int counter) {
        PreferenceManager.getInstance().setLongValue(UNREAD_REQUEST_TIMESTAMP, this.mBrandId, System.currentTimeMillis());
        PreferenceManager.getInstance().setIntValue(UNREAD_COUNT, this.mBrandId, counter);
    }

    private void returnCachedDetails() {
        LPMobileLog.d((String)TAG, (String)"Return cached unread message count");
        int counter = PreferenceManager.getInstance().getIntValue(UNREAD_COUNT, this.mBrandId, 0);
        this.notifySuccess(counter);
    }

    private boolean isRequestThresholdWasPassed(String brandId) {
        long lastTimestamp = PreferenceManager.getInstance().getLongValue(UNREAD_REQUEST_TIMESTAMP, brandId, 0L);
        long delta = System.currentTimeMillis() - lastTimestamp;
        return lastTimestamp == 0L || delta > 10000L;
    }
}

