/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.support.annotation.NonNull;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.infra.utils.UniqueID;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.commands.SendMessageCommand;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.network.http.RestRequestParams;
import com.liveperson.messaging.network.http.SendFileRequestRest;
import com.liveperson.messaging.network.socket.requests.NewConversationRequest;
import com.liveperson.messaging.network.socket.requests.SendFileRequest;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;

public abstract class SendFileCommand
extends SendMessageCommand {
    private static final String TAG = "SendFileCommand";
    private final String mFileContentType;
    private final String mFileTypeExtension;
    private String mThumbnailPath;
    private String mLocalFilePath;
    protected String mCaption;
    private String mRelativePath;
    private String mFileType;
    protected String mPreview;
    protected SendFileCommandListener mCallback;
    protected long mMessageRowId = -1L;
    private boolean sendViaRest;
    private RestRequestParams restDomain;
    private String mTempConversationId;
    private String mTempDialogId;

    protected abstract MessagingChatMessage.MessageType getMessageType(MaskedMessage var1);

    public SendFileCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message) {
        super(controller, targetId, brandId, message);
        this.mFileContentType = contentType;
        this.mThumbnailPath = thumbnailPath;
        this.mLocalFilePath = filePath;
        this.mMessage = message;
        this.mCaption = this.mMessage.getServerMessage();
        this.mFileTypeExtension = fileTypeExtension;
    }

    public void setCallback(SendFileCommandListener mCallback) {
        this.mCallback = mCallback;
    }

    public void setFileDetails(String relativePath, String fileType, String previewBase64) {
        this.mRelativePath = relativePath;
        this.mFileType = fileType;
        this.mPreview = "data:" + this.mFileContentType + ";base64," + previewBase64;
    }

    public void addMessageToDB() {
        try {
            LPMobileLog.d((String)TAG, (String)"addMessageToDB");
            String newDialogId = this.updateMessageWithCurrentDialog();
            LPMobileLog.d((String)TAG, (String)("addMessageToDB File! - dialogId = " + newDialogId));
            this.addMessageToDBAndSend(newDialogId, this.mMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String updateMessageWithCurrentDialog() {
        String newDialogId;
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        if (dialog == null) {
            LPMobileLog.i((String)TAG, (String)"updateMessageWithCurrentDialog: creating new temp dialog and conversation, there is no open one.");
            String newConversationId = Conversation.createTempConversationId();
            newDialogId = Dialog.createTempDialogId();
            this.createQueuedConversationAndDialog(newConversationId, newDialogId);
        } else {
            switch (dialog.getState()) {
                case CLOSE: {
                    LPMobileLog.i((String)TAG, (String)"updateMessageWithCurrentDialog: creating new temp dialog and conversation, they are closed.");
                    String newConversationId = Conversation.createTempConversationId();
                    newDialogId = Dialog.createTempDialogId();
                    BaseAMSSocketRequest newConversationRequest = this.createPendingConversationAndDialog(newConversationId, newDialogId);
                    this.sendCreateConversationRequest(newConversationRequest);
                    break;
                }
                default: {
                    newDialogId = dialog.getDialogId();
                    LPMobileLog.i((String)TAG, (String)("updateMessageWithCurrentDialog: getting current dialog ID: " + newDialogId + ", state: " + (Object)((Object)dialog.getState())));
                }
            }
        }
        return newDialogId;
    }

    @Override
    protected void addMessageToDBAndSend(String dialogId, MaskedMessage message) {
        this.mEventId = UniqueID.createUniqueMessageEventId();
        LPMobileLog.d((String)TAG, (String)("addMessageToDBAndSend, createNewChatMessage, ContentType: " + this.mFileContentType));
        MessagingChatMessage chatMessage = this.createNewChatMessage(dialogId, message);
        chatMessage.setContentType(this.mFileContentType);
        this.mController.amsMessages.addMessage(chatMessage, true).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Long>(){

            public void onResult(Long rowId) {
                if (rowId == -1L) {
                    LPMobileLog.d((String)SendFileCommand.TAG, (String)"onResult: message was updated on DB (and not inserted). No need to add the file to DB");
                } else {
                    LPMobileLog.d((String)SendFileCommand.TAG, (String)("addMessageToDBAndSend,  MessagingChatMessage was added. row id: " + rowId + ". Adding fileMessage to db."));
                    FileMessage fileMessage = new FileMessage(SendFileCommand.this.mThumbnailPath, SendFileCommand.this.mFileTypeExtension, SendFileCommand.this.mLocalFilePath, null, rowId);
                    long fileRowId = (Long)MessagingFactory.getInstance().getController().amsFiles.addFile(rowId, fileMessage).executeSynchronously();
                    SendFileCommand.this.mMessageRowId = rowId;
                    LPMobileLog.d((String)SendFileCommand.TAG, (String)("addMessageToDBAndSend, fileMessage was added to db. Thumbnail path: " + SendFileCommand.this.mThumbnailPath + ", local file path: " + SendFileCommand.this.mLocalFilePath));
                    SendFileCommand.this.mController.amsMessages.updateFileMessageByRowId(rowId, fileRowId).executeSynchronously();
                    if (SendFileCommand.this.mCallback != null) {
                        SendFileCommand.this.mCallback.onFileAddedToDB(SendFileCommand.this.mMessageRowId, fileRowId);
                    }
                }
            }
        }).execute();
        if (this.mMessage.isMasked()) {
            MessagingChatMessage warning = new MessagingChatMessage(chatMessage.getOriginatorId(), message.getMaskedSystemMessage(), chatMessage.getTimeStamp() + 1L, chatMessage.getDialogId(), UniqueID.createUniqueMessageEventId(), MessagingChatMessage.MessageType.SYSTEM_MASKED, MessagingChatMessage.MessageState.RECEIVED, -3, ContentType.text_plain.getText(), EncryptionVersion.NONE);
            this.mController.amsMessages.addMessage(warning, true).execute();
        }
    }

    public void updateMessageConversationId() {
        LPMobileLog.i((String)TAG, (String)"update Message dialog ID");
        String newDialogId = this.updateMessageWithCurrentDialog();
        LPMobileLog.i((String)TAG, (String)("update Message dialog ID - updating file message: " + this.mMessageRowId + " with new dialog id = " + newDialogId));
        this.mController.amsMessages.updateMessageDialogServerIdAndTime(this.mMessageRowId, newDialogId, this.getMessageTime()).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Void>(){

            public void onResult(Void data) {
                LPMobileLog.i((String)SendFileCommand.TAG, (String)"Finished updating file message ( dialog ID and new time ) ");
                if (SendFileCommand.this.mCallback != null) {
                    SendFileCommand.this.mCallback.onMessageUpdatedInDB();
                }
            }
        }).execute();
    }

    protected long getMessageTime() {
        return System.currentTimeMillis();
    }

    @Override
    public void execute() {
        LPMobileLog.i((String)TAG, (String)"Sending file message. creating new conversation if there is no open one.");
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        Dialog dialog = this.mController.amsDialogs.getActiveDialog();
        this.mConsumerId = this.mController.amsUsers.getConsumerId(this.mTargetId);
        if (dialog == null) {
            String tempConversationId = Conversation.createTempConversationId();
            String tempDialogId = Dialog.createTempDialogId();
            LPMobileLog.e((String)TAG, (String)"SHOULD NEVER HAPPEN!!");
            this.addMessageToDBAndSend(tempConversationId, this.mMessage);
            BaseAMSSocketRequest newConversationRequest = this.createPendingConversationAndDialog(tempConversationId, tempDialogId);
            this.sendCreateConversationRequest(newConversationRequest);
        } else {
            LPMobileLog.i((String)TAG, (String)("checking current dialog, state - " + (Object)((Object)dialog.getState())));
            switch (dialog.getState()) {
                case CLOSE: {
                    LPMobileLog.i((String)TAG, (String)"Dialog is closed. Fail the file message");
                    this.markMessageAsError();
                    break;
                }
                case QUEUED: {
                    LPMobileLog.i((String)TAG, (String)"Dialog is queued and waiting to be created...");
                    this.markMessageAsPending();
                    this.sendNewConversationRequest(dialog.getConversationId(), dialog.getDialogId(), dialog.getRequestId());
                    break;
                }
                case OPEN: 
                case PENDING: {
                    LPMobileLog.i((String)TAG, (String)"Dialog is open/pending. Sending message");
                    this.markMessageAsPending();
                }
            }
        }
        this.sendMessageIfDialogIsOpen();
    }

    private void markMessageAsPending() {
        LPMobileLog.i((String)TAG, (String)"Changing message state to pending.. waiting to be send...");
        this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.PENDING);
    }

    private void markMessageAsError() {
        LPMobileLog.i((String)TAG, (String)"Changing message state to Error.");
        this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.ERROR);
    }

    private void sendNewConversationRequest(String newConversationId, String newDialogId, long requestId) {
        LPMobileLog.i((String)TAG, (String)("Sending request to create new conversation. conversation id = " + newConversationId));
        NewConversationRequest newConversationRequest = this.createNewConversationRequest(newConversationId, newDialogId, requestId);
        this.mController.amsConversations.updateConversationState(this.mTargetId, newConversationId, ConversationState.PENDING);
        this.mController.amsDialogs.updateDialogState(this.mTargetId, newDialogId, DialogState.PENDING);
        SocketManager.getInstance().send((BaseSocketRequest)newConversationRequest);
    }

    private void createQueuedConversationAndDialog(String tempDialogId, String tempConversationId) {
        long requestId = BaseSocketRequest.createRequestId();
        this.createQueuedConversation(tempConversationId, requestId);
        this.createQueuedDialog(tempDialogId, tempConversationId, requestId);
    }

    private void createQueuedConversation(String tempConversationID, long requestId) {
        this.mTempConversationId = tempConversationID;
        this.mController.amsConversations.createQueuedConversation(this.mTargetId, this.mBrandId, tempConversationID, requestId);
    }

    private void createQueuedDialog(String tempDialogId, String tempConversationId, long requestId) {
        this.mTempDialogId = tempDialogId;
        this.mController.amsDialogs.createQueuedDialog(this.mTargetId, this.mBrandId, tempDialogId, tempConversationId, requestId);
    }

    @Override
    @NonNull
    protected MessagingChatMessage createNewChatMessage(String dialogId, MaskedMessage message) {
        return new MessagingChatMessage(this.mController.getOriginatorId(this.mTargetId), message.getDbMessage(), System.currentTimeMillis(), dialogId, this.mEventId, this.getMessageType(message), MessagingChatMessage.MessageState.QUEUED, EncryptionVersion.NONE);
    }

    @Override
    @NonNull
    protected SendMessageRequest createMessageRequest(Messaging mController, String eventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        SendFileRequest sendFileRequest = new SendFileRequest(mController, eventId, mTargetId, mBrandId, dialogId, conversationId);
        sendFileRequest.setFileContent(this.mCaption, this.mRelativePath, this.mFileType, this.mPreview);
        return sendFileRequest;
    }

    @Override
    protected void sendMessage(String conversationServerId, SendMessageRequest sendMessageRequest) {
        if (this.sendViaRest) {
            new SendFileRequestRest(this.restDomain, sendMessageRequest).execute();
        } else {
            super.sendMessage(conversationServerId, sendMessageRequest);
        }
    }

    public void failMessage() {
        Dialog dialog;
        Conversation conversation;
        LPMobileLog.w((String)TAG, (String)"failMessage: upload file failed");
        if (this.mMessageRowId != -1L) {
            LPMobileLog.d((String)TAG, (String)("failMessage: setting message (rowId: " + this.mMessageRowId + ") to error"));
            this.mController.amsMessages.updateMessageState(this.mMessageRowId, MessagingChatMessage.MessageState.ERROR);
        }
        if ((conversation = this.mController.amsConversations.getConversation(this.mTargetId)).getState() == ConversationState.QUEUED) {
            LPMobileLog.d((String)TAG, (String)("failMessage: conversation " + conversation.getConversationId() + " is queued. Close it"));
            ConversationData conversationData = new ConversationData();
            conversationData.conversationId = this.mTempConversationId;
            conversationData.brandId = this.mBrandId;
            conversationData.targetId = this.mTargetId;
            this.mController.amsConversations.updateClosedConversation(conversationData, false).execute();
        }
        if ((dialog = this.mController.amsDialogs.getActiveDialog()) != null && dialog.getState() == DialogState.QUEUED) {
            ConversationData conversationData = new ConversationData();
            conversationData.conversationId = this.mTempConversationId;
            conversationData.brandId = this.mBrandId;
            conversationData.targetId = this.mTargetId;
            this.mController.amsDialogs.updateClosedDialog(conversationData, dialog, false).execute();
        }
    }

    public void setSendViaRest(boolean sendViaRest, RestRequestParams restDomain) {
        this.sendViaRest = sendViaRest;
        this.restDomain = restDomain;
    }

    public static interface SendFileCommandListener {
        public void onFileAddedToDB(long var1, long var3);

        public void onMessageUpdatedInDB();
    }
}

