/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.UnregisterPushRequest;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.List;

public class UnregisterPusherCommand
implements Command {
    public static final String TAG = UnregisterPusherCommand.class.getSimpleName();
    private static final String PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister";
    private final AccountsController mAccountsController;
    private final AmsUsers mAmsUsers;
    private String mBrandId;
    private String mAppId;
    private ICallback<Void, Exception> listener;
    private boolean runImmediately;

    public UnregisterPusherCommand(AccountsController accountsController, AmsUsers amsUsers, String brandId, String appId, ICallback<Void, Exception> listener, boolean immediately) {
        this.mAccountsController = accountsController;
        this.mAmsUsers = amsUsers;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.listener = listener;
        this.runImmediately = immediately;
    }

    public void execute() {
        LPMobileLog.i((String)TAG, (String)("execute unregister for brandId " + this.mBrandId));
        String pusherDomain = this.mAccountsController.getServiceUrl(this.mBrandId, "pusher");
        if (TextUtils.isEmpty((CharSequence)pusherDomain) && TextUtils.isEmpty((CharSequence)(pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.mBrandId, null)))) {
            LPMobileLog.w((String)TAG, (String)"pusherDomain does not exists. Quit unregister push");
            this.notifySuccess();
            return;
        }
        final String pusherURL = String.format(PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId);
        String consumerId = this.mAmsUsers.getConsumerId(this.mBrandId);
        if (TextUtils.isEmpty((CharSequence)consumerId)) {
            LPMobileLog.d((String)TAG, (String)"execute: consumerId is not available. Trying to get from DB...");
            this.mAmsUsers.getUserByBrandIDFromDB(this.mBrandId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                public void onResult(MessagingUserProfile userProfile) {
                    if (userProfile != null) {
                        String originatorId = userProfile.getOriginatorId();
                        if (!TextUtils.isEmpty((CharSequence)originatorId)) {
                            UnregisterPusherCommand.this.runUnregisterPush(originatorId, pusherURL);
                            LPMobileLog.d((String)TAG, (String)("onResult: got  consumerId from DB (" + originatorId + "). Unregister push with it..."));
                        } else {
                            LPMobileLog.w((String)TAG, (String)"onResult: Cannot get consumerId from DB. Quit unregister push");
                        }
                    } else {
                        LPMobileLog.w((String)TAG, (String)"onResult: Cannot get user profile from DB. Quit unregister push");
                    }
                }
            }).setPostQueryOnUI((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

                public void onResult(MessagingUserProfile data) {
                    if (data == null || TextUtils.isEmpty((CharSequence)data.getOriginatorId())) {
                        UnregisterPusherCommand.this.notifySuccess();
                    }
                }
            }).execute();
        } else {
            this.runUnregisterPush(consumerId, pusherURL);
        }
    }

    private void notifySuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(null);
        }
    }

    private void runUnregisterPush(final String consumerId, final String pusherURL) {
        final List<String> certificates = this.mAccountsController.getCertificatePinningKeys(this.mBrandId);
        if (this.runImmediately) {
            LPMobileLog.d((String)TAG, (String)"run: Unregister push immediately");
            if (InternetConnectionService.isNetworkAvailable()) {
                new UnregisterPushRequest(pusherURL, consumerId, this.mAppId, certificates).setCallback(this.listener).execute();
            } else if (this.listener != null) {
                this.listener.onError((Throwable)new Exception("No network available"));
            }
        } else {
            new SynchronizedInternetConnectionCallback(new Runnable(){

                @Override
                public void run() {
                    LPMobileLog.d((String)TAG, (String)("run: Unregister push for consumerId: " + consumerId));
                    new UnregisterPushRequest(pusherURL, consumerId, UnregisterPusherCommand.this.mAppId, certificates).setCallback(UnregisterPusherCommand.this.listener).execute();
                }
            }).execute();
        }
    }
}

