/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;
import com.liveperson.api.request.SubscribeExConversations;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.network.socket.requests.SubscribeExConversationsRequest;

public class SubscribeExConversationsTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = SubscribeExConversationsTask.class.getSimpleName();
    protected final Messaging mController;

    public SubscribeExConversationsTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        LPMobileLog.i((String)TAG, (String)"Running SubscribeExConversation task...");
        String originatorId = this.mController.getOriginatorId(this.mBrandId);
        if (!TextUtils.isEmpty((CharSequence)originatorId)) {
            long lastUpdateTime = this.mController.mConnectionController.getLastUpdateTime(this.mBrandId);
            long clockDiff = this.mController.mConnectionController.getClockDiff(this.mBrandId);
            long minLastUpdatedTime = lastUpdateTime == 0L ? 0L : lastUpdateTime - clockDiff;
            SubscribeExConversationsRequest baseSocketRequest = new SubscribeExConversationsRequest(this.mController.mConnectionController, minLastUpdatedTime, this.mBrandId, this.mController.mAccountsController.getConnectionUrl(this.mBrandId), originatorId);
            baseSocketRequest.addCallback((ResponseCallback)new ResponseCallback<SubscribeExConversations.Response>(){

                public void onSuccess(SubscribeExConversations.Response data) {
                    SubscribeExConversationsTask.this.mCallback.onTaskSuccess();
                }

                public void onError() {
                    SubscribeExConversationsTask.this.mCallback.onTaskError(SocketTaskType.SUBSCRIBE, new Exception(TAG));
                }
            });
            SocketManager.getInstance().send((BaseSocketRequest)baseSocketRequest);
        }
    }
}

