/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.controller;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;

public class AmsReadController
implements ShutDown {
    public static final String TAG = AmsReadController.class.getSimpleName();
    private LocalBroadcastReceiver mForegroundConnectionReceiver;
    private final Messaging mController;

    public AmsReadController(Messaging messagingController) {
        this.mController = messagingController;
    }

    public void registerForegroundConnectionReceiver(String brandId) {
        this.onConnected(brandId);
        if (this.mForegroundConnectionReceiver == null) {
            this.mForegroundConnectionReceiver = new LocalBroadcastReceiver.Builder().addAction("SCREEN_FOREGROUND_ACTION").build(new LocalBroadcastReceiver.IOnReceive(){

                public void onBroadcastReceived(Context context, Intent intent) {
                    String brandId = intent.getStringExtra("brand_id");
                    String targetId = intent.getStringExtra("target_id");
                    boolean isForeground = intent.getBooleanExtra("is_foreground", false);
                    if (isForeground && ((AmsReadController)AmsReadController.this).mController.mConnectionController.isSocketReady(brandId)) {
                        LPMobileLog.d((String)TAG, (String)("Sending read ack for targetId " + targetId));
                        String originatorId = AmsReadController.this.mController.getOriginatorId(targetId);
                        ((AmsReadController)AmsReadController.this).mController.amsMessages.sendReadAckOnMessages(brandId, targetId, originatorId);
                    }
                }
            });
        } else {
            this.mForegroundConnectionReceiver.register();
        }
    }

    private void unregisterForegroundConnectionReceiver() {
        if (this.mForegroundConnectionReceiver != null) {
            this.mForegroundConnectionReceiver.unregister();
            this.mForegroundConnectionReceiver = null;
        }
    }

    private void onConnected(String brandId) {
        if (!TextUtils.isEmpty((CharSequence)brandId) && this.mController.mConnectionController.isSocketReady(brandId) && ForegroundService.getInstance().isBrandForeground(brandId)) {
            LPMobileLog.d((String)TAG, (String)(" (onConnected) Sending read ack for brandId " + brandId));
            String originatorId = MessagingFactory.getInstance().getController().getOriginatorId(brandId);
            this.mController.amsMessages.sendReadAckOnMessages(brandId, null, originatorId);
        }
    }

    public void shutDown() {
        this.unregisterForegroundConnectionReceiver();
    }
}

