/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.support.annotation.Nullable;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.FileMessage;
import java.util.ArrayList;

public class AmsFiles
extends BaseDBRepository {
    private static final String TAG = AmsFiles.class.getSimpleName();

    public AmsFiles() {
        super("files");
    }

    public DataBaseCommand<Long> addFile(final long messageRowId, final FileMessage fileMessage) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Long>(){

            public Long query() {
                LPMobileLog.d((String)TAG, (String)("Adding file: " + fileMessage.getLocalUrl() + " type: " + fileMessage.getFileType()));
                ContentValues filesValues = new ContentValues();
                filesValues.put("preview", fileMessage.getPreview());
                if (fileMessage.getLocalUrl() != null) {
                    filesValues.put("localUrl", fileMessage.getLocalUrl());
                    filesValues.put("localUrlTimestamp", Long.valueOf(System.currentTimeMillis()));
                }
                filesValues.put("fileType", fileMessage.getFileType());
                filesValues.put("loadStatus", Integer.valueOf(fileMessage.getLoadStatus().ordinal()));
                filesValues.put("swiftPath", fileMessage.getSwiftPath());
                filesValues.put("relatedMessageRowID", Long.valueOf(messageRowId));
                long rowId = AmsFiles.this.getDB().insert(filesValues);
                return rowId;
            }
        });
    }

    public void updateRelativePath(final Long fileRowId, final String relativePath) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues filesValues = new ContentValues();
                filesValues.put("swiftPath", relativePath);
                StringBuilder whereBuilder = new StringBuilder();
                whereBuilder.append("_id").append(" =? ");
                AmsFiles.this.getDB().update(filesValues, whereBuilder.toString(), new String[]{String.valueOf(fileRowId)});
            }
        });
    }

    public void updateStatus(final long fileRowId, final FilesTable.LoadStatus status) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ContentValues filesValues = new ContentValues();
                filesValues.put("loadStatus", Integer.valueOf(status.ordinal()));
                StringBuilder whereBuilder = new StringBuilder();
                whereBuilder.append("_id").append(" =? ");
                AmsFiles.this.getDB().update(filesValues, whereBuilder.toString(), new String[]{String.valueOf(fileRowId)});
                LPMobileLog.d((String)TAG, (String)("updateStatus :" + status + " file:" + fileRowId));
            }
        });
    }

    public DataBaseCommand<Void> updateLocalPath(final long fileRowId, final String path) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Void>(){

            public Void query() {
                ContentValues filesValues = new ContentValues();
                filesValues.put("localUrl", path);
                filesValues.put("localUrlTimestamp", Long.valueOf(System.currentTimeMillis()));
                StringBuilder whereBuilder = new StringBuilder();
                whereBuilder.append("_id").append(" =? ");
                AmsFiles.this.getDB().update(filesValues, whereBuilder.toString(), new String[]{String.valueOf(fileRowId)});
                return null;
            }
        });
    }

    public DataBaseCommand<ArrayList<String>> getMultipleOldestLocalPathFromDB(final String targetId, final int limit, final @Nullable String fileTypesString) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<ArrayList<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ArrayList<String> query() {
                ArrayList<String> oldFileList = new ArrayList<String>();
                StringBuilder sb = new StringBuilder();
                sb.append("select ").append("localUrl").append(" from ").append("files").append(", ").append("messages").append(", ").append("dialogs").append(" where ").append("dialogs").append(".").append("target_id").append("=").append("'").append(targetId).append("'").append(" and ").append("localUrl").append(" <> '' ");
                if (fileTypesString != null) {
                    sb.append(" and LOWER(").append("files").append(".").append("fileType").append(") in (").append(fileTypesString).append(") ");
                }
                sb.append(" and ").append("dialogs").append(".").append("dialog_id").append("=").append("messages").append(".").append("dialogId").append(" and ").append("files").append(".").append("relatedMessageRowID").append("=").append("messages").append(".").append("_id").append(" order by ").append("localUrlTimestamp").append(" limit ").append(limit).append(";");
                String sql = sb.toString();
                LPMobileLog.d((String)TAG, (String)("query: " + sql));
                Cursor cursor = AmsFiles.this.getDB().rawQuery(sql, new Object[0]);
                if (cursor != null) {
                    try {
                        if (cursor.moveToFirst()) {
                            do {
                                String localUrl = cursor.getString(0);
                                LPMobileLog.d((String)TAG, (String)("getMultipleOldestLocalPathFromDB: Add to list old file with local url: " + localUrl));
                                oldFileList.add(localUrl);
                            } while (cursor.moveToNext());
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                return oldFileList;
            }
        });
    }

    public DataBaseCommand<Integer> removeLocalPathFromDB(final String targetId, final String localUrl) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){

            public Integer query() {
                LPMobileLog.d((String)TAG, (String)("query: searching and removing localUrl: " + localUrl));
                ContentValues localPathValues = new ContentValues();
                localPathValues.put("localUrl", "");
                localPathValues.put("loadStatus", Integer.valueOf(FilesTable.LoadStatus.NOT_STARTED.ordinal()));
                FileMessage fileByLocalUrl = AmsFiles.this.getFileByLocalUrl(localUrl);
                long messageRelatedRowId = -1L;
                if (fileByLocalUrl != null) {
                    messageRelatedRowId = fileByLocalUrl.getRelatedMessageRowID();
                }
                int numOfRowsAffected = AmsFiles.this.getDB().update(localPathValues, "localUrl=?", new String[]{localUrl});
                MessagingFactory.getInstance().getController().amsMessages.updateMessageFileChanged(targetId, messageRelatedRowId);
                LPMobileLog.d((String)TAG, (String)("query: removed " + numOfRowsAffected + " records"));
                return numOfRowsAffected;
            }
        });
    }

    public DataBaseCommand<Integer> getNumOfLocalPathFromDB(final String targetId, final @Nullable String fileTypesString) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Integer query() {
                int count = 0;
                StringBuilder sb = new StringBuilder();
                sb.append("select count(*) from ").append("files").append(", ").append("messages").append(", ").append("dialogs").append(" where ").append("dialogs").append(".").append("target_id").append("=").append("'").append(targetId).append("'").append(" and ").append("localUrl").append(" <> '' ");
                if (fileTypesString != null) {
                    sb.append(" and LOWER(").append("files").append(".").append("fileType").append(") in (").append(fileTypesString).append(") ");
                }
                sb.append(" and ").append("dialogs").append(".").append("dialog_id").append("=").append("messages").append(".").append("dialogId").append(" and ").append("files").append(".").append("relatedMessageRowID").append("=").append("messages").append(".").append("_id");
                String sql = sb.toString();
                Cursor cursor = AmsFiles.this.getDB().rawQuery(sql, new Object[0]);
                if (cursor != null) {
                    try {
                        if (cursor.moveToFirst()) {
                            count = cursor.getInt(0);
                            LPMobileLog.d((String)TAG, (String)("query: number of records with localUrl: " + count));
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                return count;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMessage getFileByFileRowIdOnDbThread(long fileRowId) {
        Cursor cursor = this.getDB().rawQuery("SELECT * FROM files WHERE _id=? ", new Object[]{String.valueOf(fileRowId)});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public DataBaseCommand<FileMessage> getFileByFileRowId(final long fileRowId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<FileMessage>(){

            public FileMessage query() {
                return AmsFiles.this.getFileByFileRowIdOnDbThread(fileRowId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMessage getFileByMessageRowId(long messageRowId) {
        Cursor cursor = this.getDB().rawQuery("SELECT * FROM files WHERE relatedMessageRowID=? ", new Object[]{String.valueOf(messageRowId)});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMessage getFileByLocalUrl(String localUrl) {
        Cursor cursor = this.getDB().query(null, "localUrl=? ", new String[]{localUrl}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }
}

