/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.UsersTable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.model.MessagingUserProfile;
import java.util.HashMap;

public class AmsUsers
extends BaseDBRepository
implements Clearable {
    private static final String TAG = AmsUsers.class.getSimpleName();
    public static final String BROADCAST_CONSUMER_ID_ACTION = "BROADCAST_CONSUMER_ID_ACTION";
    public static final String BRAND_ID_EXTRA = "BRAND_ID_EXTRA";
    public static final String BROADCAST_AGENT_CHANGED = "BROADCAST_AGENT_CHANGED";
    public static final String EXTRA_KEY_AGENT_SERVER_ID = "EXTRA_KEY_AGENT_SERVER_ID";
    public static final String EXTRA_KEY_AGENT_FULL_NAME = "EXTRA_KEY_AGENT_FULL_NAME";
    public static final String EXTRA_KEY_AGENT_NICKNAME = "EXTRA_KEY_AGENT_NICKNAME";
    public static final String BROADCAST_CONSUMER_CHANGED = "BROADCAST_CONSUMER_CHANGED";
    public static final String EXTRA_KEY_ID = "EXTRA_KEY_ID";
    public static final String EXTRA_KEY_FULL_NAME = "EXTRA_KEY_FULL_NAME";
    private HashMap<String, String> mBrandIDConsumerIdMap = new HashMap();

    public AmsUsers() {
        super("users");
    }

    public String getConsumerId(String brandID) {
        LPMobileLog.d((String)TAG, (String)("getConsumerId for brand " + brandID));
        String consumerID = this.mBrandIDConsumerIdMap.get(brandID);
        return TextUtils.isEmpty((CharSequence)consumerID) ? null : consumerID;
    }

    private void setConsumerId(String brandID, String consumerId) {
        String oldConsumerID = this.mBrandIDConsumerIdMap.get(brandID);
        LPMobileLog.d((String)TAG, (String)("Adding consumer Id " + consumerId + " for brand " + brandID));
        if (!TextUtils.equals((CharSequence)oldConsumerID, (CharSequence)consumerId)) {
            this.mBrandIDConsumerIdMap.put(brandID, consumerId);
            Bundle extra = new Bundle();
            extra.putString(BRAND_ID_EXTRA, brandID);
            LocalBroadcast.sendBroadcast((String)BROADCAST_CONSUMER_ID_ACTION, (Bundle)extra);
        }
    }

    public void updateConsumerId(final String brandID, final String consumerId) {
        String oldConsumerID = this.mBrandIDConsumerIdMap.get(brandID);
        if (TextUtils.isEmpty((CharSequence)oldConsumerID)) {
            LPMobileLog.d((String)TAG, (String)("No Consumer ID - Adding consumer Id " + consumerId + " for brand " + brandID));
            this.mBrandIDConsumerIdMap.put(brandID, consumerId);
            DataBaseExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessagingUserProfile userProfile = new MessagingUserProfile("", "", UserProfile.UserType.CONSUMER);
                    userProfile.setOriginatorID(consumerId);
                    userProfile.setBrandID(brandID);
                    userProfile.setUserEncryptionVersion(EncryptionVersion.VERSION_1);
                    ContentValues messageValues = AmsUsers.this.getContentValues(userProfile);
                    AmsUsers.this.getDB().replace(messageValues);
                }
            });
        }
    }

    public void loadConsumerForBrand(String mBrandId) {
        this.loadConsumer(mBrandId);
    }

    public void updateUserProfile(final MessagingUserProfile userProfile) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                LPMobileLog.d((String)TAG, (String)("updateUserProfile type:" + (Object)((Object)userProfile.getUserType()) + ", id = " + userProfile.getOriginatorId()));
                userProfile.setUserEncryptionVersion(EncryptionVersion.VERSION_1);
                ContentValues messageValues = AmsUsers.this.getContentValues(userProfile);
                AmsUsers.this.getDB().replace(messageValues);
                if (userProfile.getUserType() == UserProfile.UserType.CONSUMER) {
                    AmsUsers.this.loadConsumer(userProfile.getBrandId());
                    Bundle extras = new Bundle();
                    extras.putString(AmsUsers.EXTRA_KEY_ID, userProfile.getOriginatorId());
                    extras.putString(AmsUsers.EXTRA_KEY_FULL_NAME, userProfile.getFullName());
                    LocalBroadcast.sendBroadcast((String)AmsUsers.BROADCAST_CONSUMER_CHANGED, (Bundle)extras);
                } else {
                    Bundle extras = new Bundle();
                    extras.putString(AmsUsers.EXTRA_KEY_AGENT_SERVER_ID, userProfile.getOriginatorId());
                    extras.putString(AmsUsers.EXTRA_KEY_AGENT_FULL_NAME, userProfile.getFullName());
                    extras.putString(AmsUsers.EXTRA_KEY_AGENT_NICKNAME, userProfile.getNickname());
                    LocalBroadcast.sendBroadcast((String)AmsUsers.BROADCAST_AGENT_CHANGED, (Bundle)extras);
                }
            }
        });
    }

    public void loadProfile(String assignedAgentServerId) {
        if (TextUtils.isEmpty((CharSequence)assignedAgentServerId)) {
            return;
        }
        this.getUserById(assignedAgentServerId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<MessagingUserProfile>(){

            public void onResult(MessagingUserProfile profile) {
                if (profile != null) {
                    if (profile.getUserType() == UserProfile.UserType.AGENT) {
                        Bundle extras = new Bundle();
                        extras.putString(AmsUsers.EXTRA_KEY_AGENT_SERVER_ID, profile.getOriginatorId());
                        LocalBroadcast.sendBroadcast((String)AmsUsers.BROADCAST_AGENT_CHANGED, (Bundle)extras);
                    } else {
                        Bundle extras = new Bundle();
                        extras.putString(AmsUsers.EXTRA_KEY_ID, profile.getOriginatorId());
                        extras.putString(AmsUsers.EXTRA_KEY_FULL_NAME, profile.getFullName());
                        LocalBroadcast.sendBroadcast((String)AmsUsers.BROADCAST_CONSUMER_CHANGED, (Bundle)extras);
                    }
                }
            }
        }).execute();
    }

    private void loadConsumer(final String mBrandId) {
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String consumerId = AmsUsers.this.getConsumerIdFromDB(mBrandId);
                AmsUsers.this.setConsumerId(mBrandId, consumerId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConsumerIdFromDB(String brandId) {
        Cursor cursor = this.getDB().query(new String[]{"originatorId"}, "userType =? AND brandId =? ", new String[]{String.valueOf(UserProfile.UserType.CONSUMER.ordinal()), brandId}, null, null, null);
        if (cursor != null) {
            try {
                String consumerId = "";
                if (cursor.moveToFirst()) {
                    int columnIndex = cursor.getColumnIndex("originatorId");
                    consumerId = cursor.getString(columnIndex);
                }
                String string2 = consumerId;
                return string2;
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public DataBaseCommand<MessagingUserProfile> getUserByBrandIDFromDB(final String brandId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<MessagingUserProfile>(){

            public MessagingUserProfile query() {
                Cursor c = AmsUsers.this.getDB().rawQuery("select * from users where brandId = ?", new Object[]{brandId});
                MessagingUserProfile userProfile = null;
                if (c != null && c.getCount() > 0) {
                    try {
                        if (c.moveToFirst()) {
                            userProfile = AmsUsers.this.getProfileFromCursor(c);
                        }
                    }
                    finally {
                        c.close();
                    }
                }
                return userProfile;
            }
        });
    }

    public DataBaseCommand<String> getConsumerByBrandIDFromDB(final String brandId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<String>(){

            public String query() {
                return AmsUsers.this.getConsumerIdFromDB(brandId);
            }
        });
    }

    public MessagingUserProfile getProfileFromCursor(Cursor cursor) {
        String firstName = cursor.getString(cursor.getColumnIndex("firstName"));
        String lastName = cursor.getString(cursor.getColumnIndex("lastName"));
        String nickName = cursor.getString(cursor.getColumnIndex("nickname"));
        String profileImage = cursor.getString(cursor.getColumnIndex("profileImage"));
        String description = cursor.getString(cursor.getColumnIndex("description"));
        String email = cursor.getString(cursor.getColumnIndex("email"));
        String mobileNumber = cursor.getString(cursor.getColumnIndex("phoneNumber"));
        int userEncryptionVersion = cursor.getInt(cursor.getColumnIndex("encryptVer"));
        EncryptionVersion currentEncryptionVersion = EncryptionVersion.fromInt((int)userEncryptionVersion);
        firstName = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)firstName);
        lastName = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)lastName);
        nickName = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)nickName);
        profileImage = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)profileImage);
        description = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)description);
        email = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)email);
        mobileNumber = DBEncryptionHelper.decrypt((EncryptionVersion)currentEncryptionVersion, (String)mobileNumber);
        MessagingUserProfile profile = new MessagingUserProfile(firstName, lastName, UserProfile.UserType.values()[cursor.getInt(cursor.getColumnIndex("userType"))]);
        profile.setNickname(nickName);
        profile.setLocalId(cursor.getLong(cursor.getColumnIndex("_id")));
        profile.setOriginatorID(cursor.getString(cursor.getColumnIndex("originatorId")));
        profile.setAvatarUrl(profileImage);
        profile.setDescription(description);
        profile.setRequestId(cursor.getInt(cursor.getColumnIndex("requestId")));
        profile.setEmail(email);
        profile.setMobileNumber(mobileNumber);
        return profile;
    }

    public DataBaseCommand<MessagingUserProfile> getUserById(final String originatorId) {
        return new DataBaseCommand((DataBaseCommand.QueryCommand)new DataBaseCommand.QueryCommand<MessagingUserProfile>(){

            public MessagingUserProfile query() {
                Cursor cursor = AmsUsers.this.getDB().query(null, "originatorId=?", new String[]{String.valueOf(originatorId)}, null, null, null);
                if (cursor != null) {
                    try {
                        if (cursor.moveToFirst()) {
                            MessagingUserProfile messagingUserProfile = AmsUsers.this.getProfileFromCursor(cursor);
                            return messagingUserProfile;
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                return null;
            }
        });
    }

    private ContentValues getContentValues(MessagingUserProfile profile) {
        ContentValues contentValues = new ContentValues();
        EncryptionVersion userEncryptionVersion = profile.getUserEncryptionVersion();
        contentValues.put("encryptVer", Integer.valueOf(userEncryptionVersion.ordinal()));
        String encryptedFirstName = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getFirstName());
        String encryptedLastName = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getLastName());
        String encryptedNickName = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getNickname());
        String encryptedAvatarUrl = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getAvatarUrl());
        String encryptedDescription = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getDescription());
        contentValues.put("firstName", encryptedFirstName);
        contentValues.put("lastName", encryptedLastName);
        contentValues.put("nickname", encryptedNickName);
        contentValues.put("profileImage", encryptedAvatarUrl);
        contentValues.put("description", encryptedDescription);
        if (profile.getPrivateData() != null) {
            String encryptedEmail = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getPrivateData().mail);
            String encryptedMobileNumber = DBEncryptionHelper.encrypt((EncryptionVersion)userEncryptionVersion, (String)profile.getPrivateData().mobileNum);
            contentValues.put("email", encryptedEmail);
            contentValues.put("phoneNumber", encryptedMobileNumber);
        }
        contentValues.put("requestId", Long.valueOf(profile.getRequestId()));
        contentValues.put("originatorId", profile.getOriginatorId());
        contentValues.put("brandId", profile.getBrandId());
        if (profile.getUserType() != null) {
            contentValues.put("userType", Integer.valueOf(profile.getUserType().ordinal()));
        }
        return contentValues;
    }

    public String[] getProjection() {
        return UsersTable.getProjection();
    }

    public void clearConsumerFromDB(String mBrandId) {
        final String consumerId = this.getConsumerIdFromDB(mBrandId);
        this.clear();
        DataBaseExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                int rowIdDeleted = AmsUsers.this.getDB().removeAll("originatorId=?", new String[]{String.valueOf(consumerId)});
                if (rowIdDeleted == -1) {
                    LPMobileLog.d((String)TAG, (String)"Could not find old consumer user");
                } else {
                    LPMobileLog.d((String)TAG, (String)"Deleted old consumer user");
                }
            }
        });
    }

    public void clear() {
        this.mBrandIDConsumerIdMap.clear();
    }
}

