/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.Command;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.controller.ConnectionsController;

public class SynchronizedAmsConnectionUpdateCallback
implements Command {
    private static final String TAG = SynchronizedAmsConnectionUpdateCallback.class.getSimpleName();
    private final ConnectionsController mConnectionController;
    private String mBrandId;
    private boolean handled = false;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private Runnable mCallback;

    public SynchronizedAmsConnectionUpdateCallback(ConnectionsController connectionController, String brandId, Runnable callback) {
        this.mConnectionController = connectionController;
        this.mBrandId = brandId;
        this.mCallback = callback;
    }

    public void execute() {
        this.registerToConnectionStateChanges();
        this.validateStatusDidNotChangedDuringRegistration();
    }

    private void registerToConnectionStateChanges() {
        this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_AMS_CONNECTION_UPDATE_ACTION").build(new LocalBroadcastReceiver.IOnReceive(){

            public void onBroadcastReceived(Context context, Intent intent) {
                LPMobileLog.d((String)TAG, (String)"received BROADCAST_AMS_CONNECTION_UPDATE_ACTION - call connection update");
                boolean isUpdated = intent.getBooleanExtra("BROADCAST_AMS_CONNECTION_UPDATE_EXTRA", false);
                if (isUpdated) {
                    SynchronizedAmsConnectionUpdateCallback.this.handleConnectionUpdated();
                }
            }
        });
    }

    private synchronized void validateStatusDidNotChangedDuringRegistration() {
        if (!this.handled && this.mConnectionController.isUpdated(this.mBrandId)) {
            this.handleConnectionUpdated();
        }
    }

    private synchronized void handleConnectionUpdated() {
        if (this.handled) {
            return;
        }
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
        }
        this.handled = true;
        this.mCallback.run();
    }
}

