/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network;

import android.os.Message;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.DispatchQueue;
import com.liveperson.infra.utils.HandleMessageCallback;
import com.liveperson.messaging.network.http.MessageTimeoutListener;

public class MessageTimeoutQueue
implements HandleMessageCallback {
    private static final String TAG = MessageTimeoutQueue.class.getSimpleName();
    private static final int PUBLISH_TIMEOUT = 40000;
    private static final int KEEP_ALIVE_TIMEOUT = 15000;
    private final MessageTimeoutListener mMessageTimeoutListener;
    private DispatchQueue mMessagesQueue;

    public MessageTimeoutQueue(MessageTimeoutListener messageTimeoutListener) {
        this.mMessageTimeoutListener = messageTimeoutListener;
        this.mMessagesQueue = new DispatchQueue(TAG, 10);
        this.mMessagesQueue.setHandleMessageCallback((HandleMessageCallback)this);
    }

    public void add(MessageType type, int requestId, String brandId, String dialogId, String eventId) {
        this.add(type, requestId, brandId, dialogId, eventId, 0);
    }

    public void add(MessageType type, int requestId, String brandId, String dialogId, int delay) {
        this.add(type, requestId, brandId, dialogId, null, delay);
    }

    public void add(MessageType type, int requestId, String brandId, String dialogId, String eventId, int delay) {
        LPMobileLog.d((String)TAG, (String)("Adding message. requestId: " + requestId + " brandId: " + brandId + " dialogId: " + dialogId));
        Message msg = Message.obtain();
        msg.what = requestId;
        msg.obj = new BrandConversationObj(brandId, dialogId, type, eventId);
        if (type == MessageType.PUBLISH) {
            this.mMessagesQueue.sendMessage(msg, 40000 + delay);
        } else if (type == MessageType.KEEP_ALIVE) {
            this.remove(requestId);
            this.mMessagesQueue.sendMessage(msg, 15000 + delay);
        }
    }

    public void handleMsgImmediately(MessageType type, int requestId, String brandId, String conversationId, String eventId) {
        if (!this.remove(requestId)) {
            return;
        }
        LPMobileLog.d((String)TAG, (String)("Sending message now. requestId: " + requestId + " brandId: " + brandId + " conversationId: " + conversationId));
        Message msg = Message.obtain();
        msg.what = requestId;
        msg.obj = new BrandConversationObj(brandId, conversationId, type, eventId);
        if (type == MessageType.PUBLISH) {
            this.mMessagesQueue.sendMessage(msg, 0);
        } else if (type == MessageType.KEEP_ALIVE) {
            this.remove(requestId);
            this.mMessagesQueue.sendMessage(msg, 0);
        }
    }

    public boolean remove(int requestId) {
        LPMobileLog.d((String)TAG, (String)("Remove message from queue. requestId: " + requestId));
        return this.mMessagesQueue.removeMessage(requestId);
    }

    public void removeAll() {
        LPMobileLog.d((String)TAG, (String)"Remove all messages from queue.");
        this.mMessagesQueue.cleanupQueue();
    }

    public void onHandleMessage(Message msg) {
        int requestId = msg.what;
        BrandConversationObj brandConversationObj = (BrandConversationObj)msg.obj;
        LPMobileLog.d((String)TAG, (String)("Timeout expired on messages. Set state to Error. requestId: " + requestId + " brandId: " + brandConversationObj.brandId + " conversationId: " + brandConversationObj.dialogId));
        if (brandConversationObj.type == MessageType.PUBLISH) {
            this.mMessageTimeoutListener.onPublishMessageTimeout(brandConversationObj.brandId, brandConversationObj.eventId, brandConversationObj.dialogId);
        }
        this.mMessageTimeoutListener.onMessageTimeout(brandConversationObj.brandId);
    }

    private static class BrandConversationObj {
        String brandId;
        String dialogId;
        MessageType type;
        String eventId;

        public BrandConversationObj(String brandId, String dialogId, MessageType type, String eventId) {
            this.brandId = brandId;
            this.dialogId = dialogId;
            this.type = type;
            this.eventId = eventId;
        }
    }

    public static enum MessageType {
        KEEP_ALIVE,
        PUBLISH;

    }
}

