/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ConsumerRequestConversation;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.RequestConversation;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.MessagingChatMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class NewConversationRequest
extends BaseAMSSocketRequest<RequestConversation.Response, NewConversationRequest> {
    private static final String TAG = NewConversationRequest.class.getSimpleName();
    private final Messaging mController;
    private final String mBrandId;
    private final String mTargetId;
    private String appId = "";
    private TTRType ttrType = TTRType.NORMAL;
    private String skill = "";
    private String mTempConversationId;
    private String mTempDialogId;

    public NewConversationRequest(Messaging controller, String targetId, String brandId, String tempConversationId, String tempDialogId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mTempConversationId = tempConversationId;
        this.mTempDialogId = tempDialogId;
    }

    public NewConversationRequest setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public NewConversationRequest setTtrType(TTRType ttrType) {
        this.ttrType = ttrType;
        return this;
    }

    public NewConversationRequest setSkill(String skill) {
        this.skill = skill;
        return this;
    }

    protected String getData() {
        CampaignInfo campaignInfo = this.mController.getConversationViewParams().getCampaignInfo();
        LPMobileLog.d((String)TAG, (String)("getData: campaignInfo = " + campaignInfo));
        return new ConsumerRequestConversation(this.appId, this.ttrType, this.mBrandId, this.skill, campaignInfo).toJsonString(this.getRequestId());
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<RequestConversation.Response, NewConversationRequest> getResponseHandler() {
        return new BaseResponseHandler<RequestConversation.Response, NewConversationRequest>(){

            public String getAPIResponseType() {
                return "cm.RequestConversationResponse";
            }

            protected RequestConversation.Response parse(JSONObject jsonObject) throws JSONException {
                return new RequestConversation.Response(jsonObject);
            }

            protected boolean handle(RequestConversation.Response data) {
                if (data.code >= 200 && data.code < 300) {
                    LPMobileLog.d((String)TAG, (String)("Succeeded, create conversation response code: " + data.code));
                } else {
                    LPMobileLog.e((String)TAG, (String)("Error, create conversation response code: " + data.code));
                }
                return true;
            }

            protected void giveUp() {
                super.giveUp();
                if (NewConversationRequest.this.isConversationWaitingForResponse()) {
                    LPMobileLog.e((String)TAG, (String)(NewConversationRequest.this.getRequestId() + ": Request lost (socket closed) for newConversationRequest, Changing all messages of this conversation to error state"));
                    NewConversationRequest.this.failConversationAnsMessages();
                }
            }

            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = this.getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null) {
                    return supportedResponseHandler;
                }
                return this;
            }

            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals((CharSequence)messageType, (CharSequence)"StringResponse")) {
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>(){

                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        public String getAPIResponseType() {
                            return "StringResponse";
                        }

                        protected boolean handle(ReqBody.StringResp response) {
                            LPMobileLog.i((String)TAG, (String)("Received String response (" + response.code + ")."));
                            if (response.code >= 400) {
                                LPMobileLog.e((String)TAG, (String)("Bad response (" + response.code + ") for newConversationRequest, Changing all messages of this conversation to error state\nString response: " + response));
                                NewConversationRequest.this.failConversationAnsMessages();
                                return true;
                            }
                            return false;
                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }
        };
    }

    private void failConversationAnsMessages() {
        ConversationData conversationData = new ConversationData();
        conversationData.requestId = this.getRequestId();
        conversationData.conversationId = this.mTempConversationId;
        conversationData.brandId = this.mBrandId;
        conversationData.targetId = this.mTargetId;
        this.mController.amsConversations.updateClosedConversation(conversationData, false).execute();
        this.mController.amsDialogs.updateClosedDialog(conversationData, false).execute();
        this.mController.amsMessages.updateAllMessagesStateByDialogId(this.mTargetId, this.mTempDialogId, MessagingChatMessage.MessageState.ERROR);
    }

    private boolean isConversationWaitingForResponse() {
        return this.mController.amsConversations.getConversation(this.mTargetId) != null && this.mController.amsConversations.getConversation(this.mTargetId).getConversationId().equals(this.mTempConversationId);
    }
}

