package com.liveperson.api.request;

import com.liveperson.api.response.model.UserProfile;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Shayl on 8/9/2015.
 */
public class SetUserProfile extends AbstractRequest {

    private static final String TAG = SetUserProfile.class.getSimpleName();

    public UserProfile currentProfile;

    public SetUserProfile(UserProfile profile) {
        super();
        currentProfile = profile;
    }

    @Override
    public String getMessageType() {
        return "userprofile.SetUserProfile";
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        currentProfile.addToJson(body);
        json.put(AbstractRequest.JSON_KEY_BODY, body);
    }
}
