package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

/**
 * A command for sending message
 */
public class ReSendImageCommand extends SendImageCommand {

    private static final String TAG = ReSendImageCommand.class.getSimpleName();
    private long mFileRowId;
    private long mOriginalMessageTime;

    /**
     * Creates a command for sending messages
     *
     * @param controller
     * @param message
     */
    public ReSendImageCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String imagePath,
                              String fileExtension, String eventId,  MaskedMessage message , long originalMessageTime,long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, imagePath, fileExtension, message);
        mOriginalMessageTime = originalMessageTime;
        mFileRowId = fileRowId;
        mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        // TODO: 10/5/16 check if image and message exists in DB - if not - add them.
        mController.amsMessages.updateMessageState(mEventId,mTargetId,conversationId, MessagingChatMessage.MessageState.QUEUED);
        mController.amsMessages.getRowIdByEventId(mEventId).setPostQueryOnBackground(new DataBaseCommand.QueryCallback<Long>() {
            @Override
            public void onResult(Long data) {
                mMessageRowId = data;
                if (mCallback != null) {
                    mCallback.onFileAddedToDB(mMessageRowId,mFileRowId);
                }
            }
        }).execute();
    }

    @Override
    protected long getMessageTime() {
        return mOriginalMessageTime;
    }
}