package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;

import java.util.List;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task to obtain user data
 */
public class RefreshNotUpdatedConversationsTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = RefreshNotUpdatedConversationsTask.class.getSimpleName();
    private final Messaging mController;

    public RefreshNotUpdatedConversationsTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
        new SynchronizedAmsConnectionUpdateCallback(mController.mConnectionController, mBrandId, new Runnable() {
            @Override
            public void run() {
                LPMobileLog.d(TAG, "run RefreshNotUpdatedConversationsTask");
                mController.amsConversations.getNotUpdatedConversations(mBrandId)
                        .setPostQueryOnBackground(
                                new DataBaseCommand.QueryCallback<List<Conversation>>() {
                                    @Override
                                    public void onResult(List<Conversation> conversations) {
                                        FetchConversationManager fetchConversationManager = new FetchConversationManager(mController);

                                        if (conversations == null || conversations.size() == 0) {
                                            LPMobileLog.d(TAG, "All conversation are up to date.");
                                        } else {
                                            for (Conversation conversation : conversations) {
                                                LPMobileLog.d(TAG, "refreshing conversation : " + conversation.getConversationId());

                                                String conversationServerId = conversation.getConversationId();
                                                mController.amsConversations.setUpdateRequestInProgress(conversationServerId, 0);
                                                fetchConversationManager.refreshConversation(conversation);
                                            }

                                            LPMobileLog.d(TAG, "finished refreshing " + conversations.size() + " conversations");
                                        }
                                    }
                                }).execute();
            }
        }).execute();
        mCallback.onTaskSuccess();


    }

}