package com.liveperson.messaging.controller.connection.connectionevents;


import com.liveperson.infra.statemachine.BaseEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.messaging.controller.connection.BaseConnectionState;

/**
 * Created by shiranr on 13/03/2016.
 */
public class RunTaskEvent extends BaseEvent {
    int retry = 0;
    private int mTaskNumber;

    public RunTaskEvent() {
        super("RunTaskEvent");
    }

    public RunTaskEvent(int taskNumber, int retry) {
        super("RunTaskEvent");
        mTaskNumber = taskNumber;
        this.retry = retry;
    }

    @Override
    public void accept(IState state) {
        ((BaseConnectionState) state).visit(this);
    }

    @Override
    public String toString() {
        return super.toString() + " #" + mTaskNumber;
    }
}