package com.liveperson.messaging.structuredcontent.model.elements;

import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.Visitable;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * This is the base for all structured content entities (basic element, complex element (layout) and action).
 */
public abstract class BaseElement implements Visitable {

	/**
	 * The type of this element
	 */
	protected String mType;
	public boolean mAllowBorderBottom = true;
	public boolean mAllowBorderLeft = true;
	public boolean mAllowBorderTop = true;
	public boolean mAllowBorderRight = true;

	/**
	 *
	 * @param type
	 */
	public BaseElement(String type){
		mType = type;
	}

	/**
	 * This constructor gets the type from the given json
	 * @param jsonObject
	 * @throws JSONException
	 */
	public BaseElement (JSONObject jsonObject) throws JSONException {

		mType = jsonObject.getString(ElementType.TYPE);
	}

	public abstract String toString();

	public String getType() {
		return mType;
	}

	public void setAllowedBorders(boolean bottom, boolean left, boolean top, boolean right) {
		mAllowBorderBottom = bottom;
		mAllowBorderLeft = left;
		mAllowBorderTop = top;
		mAllowBorderRight = right;
	}
}
