package com.liveperson.messaging.utils;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.background.filesharing.FileSharingType;

public class FileSharingUtils {

    private static final String TAG = "FileSharingUtils";

    /**
     * return file type based on file uri
     * @param uri
     * @return
     */
    public static FileSharingType getFileSharingTypeFromUri(String uri, Context context) {
        try {
            Uri fileUri = Uri.parse(uri);
            String mimeType = context.getContentResolver().getType(fileUri);
            String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            return FileSharingType.getFileTypeFromExtension(extension);
        } catch (Exception e) {
            LPMobileLog.e(TAG, "Failed to get file sharing type.", e);
            return null;
        }
    }

    /**
     * return true if document type: docx, pptx, xlsx, pdf
     * @param fileType
     * @return
     */
    public static boolean isDocumentType(FileSharingType fileType) {
        return fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT;
    }
}
