/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing.document;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.utils.DocumentUtils;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.Utils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.document.UploadDocumentTaskBundle;
import com.liveperson.messaging.commands.ReSendDocumentCommand;
import com.liveperson.messaging.commands.SendDocumentCommand;
import com.liveperson.messaging.exception.FileSharingException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UploadDocumentTask
extends BaseUploadTask {
    public static final String TAG = "UploadDocumentTask";
    protected UploadDocumentTaskBundle uploadDocumentTaskBundle;
    private String previewBase64;
    protected String previewContentType;
    private Context mContext;
    private long MAX_FILE_SIZE = 5000000L;

    public UploadDocumentTask(Context context, UploadDocumentTaskBundle params, Integer uploadTimeout, boolean isReUploadRequest) throws FileSharingException {
        super(uploadTimeout);
        if (params == null) {
            throw new FileSharingException("Params is null");
        }
        this.mContext = context;
        this.uploadDocumentTaskBundle = params;
        this.generateFileByteArray(this.uploadDocumentTaskBundle.getFileUri());
        String filePath = null;
        try {
            filePath = DocumentUtils.saveOriginalDocument((Uri)this.uploadDocumentTaskBundle.getFileUri(), (Context)this.mContext, (String)this.uploadDocumentTaskBundle.getBrandId(), (byte[])this.mOriginalFileByteArray);
        }
        catch (Exception e) {
            LPMobileLog.e((String)TAG, (String)"Failed to copy file into app's local directory.", (Throwable)e);
        }
        if (filePath == null) {
            filePath = params.getFilePath();
        }
        this.generatePreviewImage();
        if (isReUploadRequest) {
            this.createReSendMessageCommand(this.createThumbnail(), filePath);
        } else {
            this.createSendMessageCommand(this.createThumbnail(), filePath);
        }
    }

    private void generateFileByteArray(Uri uri) throws FileSharingException {
        try {
            InputStream inputStream;
            int fileSize = DocumentUtils.getDocumentSize((Uri)uri, (Context)this.mContext);
            if ((long)fileSize > this.MAX_FILE_SIZE) {
                throw new FileSharingException("Unsupported file size");
            }
            byte[] bytes = new byte[fileSize];
            String fileScheme = uri.getScheme();
            if (fileScheme != null && fileScheme.equals("content")) {
                inputStream = this.mContext.getContentResolver().openInputStream(uri);
            } else {
                File file = new File(uri.toString());
                inputStream = new FileInputStream(file);
            }
            BufferedInputStream buf = new BufferedInputStream(inputStream);
            buf.read(bytes, 0, bytes.length);
            buf.close();
            this.mOriginalFileByteArray = bytes;
        }
        catch (IOException e) {
            LPMobileLog.e((String)TAG, (String)"Failed to generate document's byte array.", (Throwable)e);
        }
    }

    private void generatePreviewImage() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)Utils.getResources(), (int)R.drawable.lp_messaging_dummy_file_thumbnal);
        this.previewBase64 = ImageUtils.bitmapToBase64((Bitmap)bitmap);
        this.previewContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension("png");
    }

    protected void createSendMessageCommand(String thumbnailPath, String filePath) {
        this.sendMessageCommand = new SendDocumentCommand(MessagingFactory.getInstance().getController(), this.uploadDocumentTaskBundle.getTargetId(), this.uploadDocumentTaskBundle.getBrandId(), this.uploadDocumentTaskBundle.getFileContentType(), thumbnailPath, filePath, this.uploadDocumentTaskBundle.getFileTypeExtension(), this.uploadDocumentTaskBundle.getMessage(), this.previewContentType);
        this.setSendMessageCommandCallback();
    }

    protected void createReSendMessageCommand(String thumbnailPath, String filePath) {
        this.sendMessageCommand = new ReSendDocumentCommand(MessagingFactory.getInstance().getController(), this.uploadDocumentTaskBundle.getTargetId(), this.uploadDocumentTaskBundle.getBrandId(), this.uploadDocumentTaskBundle.getFileContentType(), thumbnailPath, filePath, this.uploadDocumentTaskBundle.getFileTypeExtension(), this.uploadDocumentTaskBundle.getMessage(), this.previewContentType, this.uploadDocumentTaskBundle.getEventId(), this.uploadDocumentTaskBundle.getOriginalMessageTime(), this.uploadDocumentTaskBundle.getFileRowId());
        this.setSendMessageCommandCallback();
    }

    private String createThumbnail() {
        return null;
    }

    @Override
    protected UploadFileTaskBundle getUploadTaskBundle() {
        return this.uploadDocumentTaskBundle;
    }

    @Override
    protected byte[] getFileByteArray() {
        return this.mOriginalFileByteArray;
    }

    @Override
    public int getTaskId() {
        return this.uploadDocumentTaskBundle.getTaskId();
    }

    @Override
    public String getThumbnailBase64() {
        return this.previewBase64;
    }
}

