/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.SendImageCommand;
import com.liveperson.messaging.model.MessagingChatMessage;

public class ReSendImageCommand
extends SendImageCommand {
    private static final String TAG = ReSendImageCommand.class.getSimpleName();
    private long mFileRowId;
    private long mOriginalMessageTime;

    public ReSendImageCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String imagePath, String fileExtension, String eventId, MaskedMessage message, long originalMessageTime, long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, imagePath, fileExtension, message);
        this.mOriginalMessageTime = originalMessageTime;
        this.mFileRowId = fileRowId;
        this.mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        this.mController.amsMessages.updateMessageState(this.mEventId, this.mTargetId, conversationId, MessagingChatMessage.MessageState.QUEUED);
        this.mController.amsMessages.getRowIdByEventId(this.mEventId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<Long>(){

            public void onResult(Long data) {
                ReSendImageCommand.this.mMessageRowId = data;
                if (ReSendImageCommand.this.mCallback != null) {
                    ReSendImageCommand.this.mCallback.onFileAddedToDB(ReSendImageCommand.this.mMessageRowId, ReSendImageCommand.this.mFileRowId);
                }
            }
        }).execute();
    }

    @Override
    protected long getMessageTime() {
        return this.mOriginalMessageTime;
    }
}

