/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.state.SocketStateAdapter;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import com.liveperson.messaging.commands.tasks.BaseAmsAccountConnectionTask;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

public class CloseConnectionTask
extends BaseAmsAccountConnectionTask {
    public static final String TAG = "CloseConnectionTask";
    private AccountsController mAccountsController;

    public CloseConnectionTask(AccountsController accountsController) {
        this.mAccountsController = accountsController;
    }

    public void execute() {
        LPMobileLog.d((String)TAG, (String)"Running close socket task...");
        AmsConnectionAnalytics.closeConnectionTaskStart();
        String connectionUrl = this.mAccountsController.getConnectionUrl(this.mBrandId);
        SocketState state = SocketManager.getInstance().getSocketState(connectionUrl);
        LPMobileLog.i((String)TAG, (String)("Current socket state: " + state));
        switch (state) {
            case CONNECTING: 
            case CLOSING: 
            case OPEN: {
                this.registerToSocketState(connectionUrl);
                SocketManager.getInstance().disconnect(connectionUrl);
                break;
            }
            default: {
                this.mCallback.onTaskSuccess();
            }
        }
    }

    private void registerToSocketState(final String connectionUrl) {
        SocketManager.getInstance().registerToSocketState(connectionUrl, (SocketStateListener)new SocketStateAdapter(){

            public void onStateChanged(SocketState state) {
                LPMobileLog.i((String)CloseConnectionTask.TAG, (String)("new socket state:" + state.name()));
                switch (state) {
                    case ERROR: 
                    case CLOSED: {
                        SocketManager.getInstance().unregisterFromSocketState(connectionUrl, (SocketStateListener)this);
                        AmsConnectionAnalytics.closeConnectionTaskEnd();
                        CloseConnectionTask.this.mCallback.onTaskSuccess();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public String getName() {
        return TAG;
    }
}

