/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.SynchronizedAmsConnectionUpdateCallback;
import java.util.List;

public class RefreshNotUpdatedConversationsTask
extends BaseAmsSocketConnectionTask {
    private static final String TAG = RefreshNotUpdatedConversationsTask.class.getSimpleName();
    private final Messaging mController;

    public RefreshNotUpdatedConversationsTask(Messaging controller) {
        this.mController = controller;
    }

    public void execute() {
        new SynchronizedAmsConnectionUpdateCallback(this.mController.mConnectionController, this.mBrandId, new Runnable(){

            @Override
            public void run() {
                LPMobileLog.d((String)TAG, (String)"run RefreshNotUpdatedConversationsTask");
                ((RefreshNotUpdatedConversationsTask)RefreshNotUpdatedConversationsTask.this).mController.amsConversations.getNotUpdatedConversations(RefreshNotUpdatedConversationsTask.this.mBrandId).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<List<Conversation>>(){

                    public void onResult(List<Conversation> conversations) {
                        FetchConversationManager fetchConversationManager = new FetchConversationManager(RefreshNotUpdatedConversationsTask.this.mController);
                        if (conversations == null || conversations.size() == 0) {
                            LPMobileLog.d((String)TAG, (String)"All conversation are up to date.");
                        } else {
                            for (Conversation conversation : conversations) {
                                LPMobileLog.d((String)TAG, (String)("refreshing conversation : " + conversation.getConversationId()));
                                String conversationServerId = conversation.getConversationId();
                                ((RefreshNotUpdatedConversationsTask)RefreshNotUpdatedConversationsTask.this).mController.amsConversations.setUpdateRequestInProgress(conversationServerId, 0);
                                fetchConversationManager.refreshConversation(conversation);
                            }
                            LPMobileLog.d((String)TAG, (String)("finished refreshing " + conversations.size() + " conversations"));
                        }
                    }
                }).execute();
            }
        }).execute();
        this.mCallback.onTaskSuccess();
    }
}

